/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.TabelViewDialog;
import ch.sahits.game.graphic.image.impl.XMLImageLoader;
import ch.sahits.game.javafx.control.BaleAmountAlwaysVisible;
import ch.sahits.game.javafx.control.BarrelAmountAlwaysVisible;
import ch.sahits.game.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ETradeType;
import ch.sahits.game.openpatrician.model.building.IAutomatedTrading;
import ch.sahits.game.openpatrician.model.building.ISteward;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.impl.Steward;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
public class AutomaticTradingOverviewDialog
extends TabelViewDialog {
    private final ETradeType[] types = new ETradeType[]{ETradeType.NONE, ETradeType.OFFICE_CITY, ETradeType.CITY_OFFICE};
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private XMLImageLoader imageLoader;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    protected final ICityPlayerProxyJFX city;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    private final Font font;

    public AutomaticTradingOverviewDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
    }

    @PostConstruct
    private void initializeTitle() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.automatic.trading", new Object[0], this.locale.getCurrentLocal()));
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }

    @PostConstruct
    private void initializeModelAndDialog() {
        Table model = this.createModel();
        if (model != null) {
            this.setModel(model);
        }
        ITradingOffice office = this.city.getPlayer().findTradingOffice(this.city.getCity());
        HBox box = new HBox();
        box.setSpacing(15.0);
        box.setLayoutX(30.0);
        box.setLayoutY(627.0);
        Text label = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.kontor.manager", new Object[0], this.locale.getCurrentLocal()));
        label.setFont(this.font);
        box.getChildren().add((Object)label);
        OpenPatricianLargeWaxButton hireButton = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.hire", new Object[0], this.locale.getCurrentLocal()), this.font);
        hireButton.textProperty().bind((ObservableValue)new HireButtonTextBinding(office));
        hireButton.onActionProperty().bind((ObservableValue)new HireActionBinding(office));
        box.getChildren().add((Object)hireButton);
        this.getContent().add((Object)box);
    }

    private Table createModel() {
        ITradingOffice office = this.city.getPlayer().findTradingOffice(this.city.getCity());
        ISteward steward = office.getSteward();
        if (steward != null) {
            return this.createAutomaticTradingModel();
        }
        return null;
    }

    private Table createAutomaticTradingModel() {
        ITradingOffice office = this.city.getPlayer().findTradingOffice(this.city.getCity());
        Table model = new Table();
        TableHeader header = new TableHeader(10);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ware", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.amount", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(""));
        Image dontMove = this.imageLoader.getImage("dontMoveOnShipIcon", 96.0, 48.0);
        ImageView headerIcon = new ImageView(dontMove);
        header.add((ITableCell)new ControlTableCell((Node)headerIcon));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.price", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.setAligenment(0, HPos.RIGHT);
        header.setAligenment(1, HPos.LEFT);
        header.setAligenment(2, HPos.LEFT);
        header.setAligenment(3, HPos.RIGHT);
        header.setAligenment(4, HPos.LEFT);
        header.setAligenment(5, HPos.LEFT);
        header.setAligenment(6, HPos.LEFT);
        header.setAligenment(7, HPos.LEFT);
        header.setAligenment(8, HPos.RIGHT);
        header.setAligenment(9, HPos.LEFT);
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.LEFT);
        model.setAligenment(2, HPos.LEFT);
        model.setAligenment(3, HPos.RIGHT);
        model.setAligenment(4, HPos.LEFT);
        model.setAligenment(5, HPos.LEFT);
        model.setAligenment(6, HPos.LEFT);
        model.setAligenment(7, HPos.LEFT);
        model.setAligenment(8, HPos.RIGHT);
        model.setAligenment(9, HPos.LEFT);
        model.setColumnWidth(new Integer[]{60, 62, 24, 70, 24, 24, 24, 30, 70, 24});
        final IAutomatedTrading autoTrading = office.getOfficeTrading();
        Image minus = this.imageLoader.getImage("minusIcon");
        Image plus = this.imageLoader.getImage("plusIcon");
        final Image unchecked = this.imageLoader.getImage("waxseal_24x24");
        final Image checked = this.imageLoader.getImage("waxseal_checked_icon");
        for (final EWare ware : EWare.values()) {
            BarrelAmountAlwaysVisible amount;
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(ware)));
            final ObjectProperty tradeType = autoTrading.tradingTypeProperty((IWare)ware);
            TradingSwitchObjectBinding iconBinding = new TradingSwitchObjectBinding((ObjectProperty<ETradeType>)tradeType);
            ImageView icon = new ImageView();
            icon.imageProperty().bind((ObservableValue)iconBinding);
            Label tradeTypeLbl = new Label("", (Node)icon);
            tradeTypeLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    ETradeType nextTradeType = (ETradeType)tradeType.get();
                    for (int i = 0; i < AutomaticTradingOverviewDialog.this.types.length; ++i) {
                        if (nextTradeType != AutomaticTradingOverviewDialog.this.types[i]) continue;
                        nextTradeType = AutomaticTradingOverviewDialog.this.types[(i + 1) % AutomaticTradingOverviewDialog.this.types.length];
                        break;
                    }
                    tradeType.set((Object)nextTradeType);
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)tradeTypeLbl));
            Label reduceAmountLbl = new Label("", (Node)new ImageView(minus));
            reduceAmountLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    autoTrading.updateAmount((IWare)ware, -1);
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)reduceAmountLbl));
            if (ware.isBarrelSizedWare()) {
                amount = new BarrelAmountAlwaysVisible(this.font);
                amount.amountProperty().bind((ObservableValue)autoTrading.amountProperty((IWare)ware).asString());
                row.add((ITableCell)new ControlTableCell((Node)amount));
            } else {
                amount = new BaleAmountAlwaysVisible(this.font);
                amount.amountProperty().bind((ObservableValue)autoTrading.amountProperty((IWare)ware).asString());
                row.add((ITableCell)new ControlTableCell((Node)amount));
            }
            Label increaseAmountLbl = new Label("", (Node)new ImageView(plus));
            increaseAmountLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    autoTrading.updateAmount((IWare)ware, 1);
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)increaseAmountLbl));
            ImageView checkedIcon = new ImageView();
            checkedIcon.imageProperty().bind((ObservableValue)new ObjectBinding<Image>(){
                {
                    super.bind(new Observable[]{autoTrading.movableToShipProperty((IWare)ware)});
                }

                protected Image computeValue() {
                    if (autoTrading.isMovableToShip((IWare)ware)) {
                        return unchecked;
                    }
                    return checked;
                }
            });
            Label checkedLbl = new Label("", (Node)checkedIcon);
            checkedLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    autoTrading.setMovableToShip((IWare)ware, !autoTrading.isMovableToShip((IWare)ware));
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)checkedLbl));
            Text priceTypeText = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.min", new Object[0], this.locale.getCurrentLocal()));
            priceTypeText.setFont(this.font);
            priceTypeText.visibleProperty().bind((ObservableValue)new VisibleTradeTypeBinding(autoTrading.tradingTypeProperty((IWare)ware)));
            row.add((ITableCell)new ControlTableCell((Node)priceTypeText));
            Label decreasePriceLbl = new Label("", (Node)new ImageView(minus));
            decreasePriceLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    autoTrading.updatePrice((IWare)ware, -1);
                }
            });
            decreasePriceLbl.visibleProperty().bind((ObservableValue)new VisibleTradeTypeBinding(autoTrading.tradingTypeProperty((IWare)ware)));
            row.add((ITableCell)new ControlTableCell((Node)decreasePriceLbl));
            CoinPriceAlwaysVisible price = new CoinPriceAlwaysVisible(this.font);
            price.amountProperty().bind((ObservableValue)autoTrading.priceProperty((IWare)ware).asString());
            price.visibleProperty().bind((ObservableValue)new VisibleTradeTypeBinding(autoTrading.tradingTypeProperty((IWare)ware)));
            row.add((ITableCell)new ControlTableCell((Node)price));
            Label increasePriceLbl = new Label("", (Node)new ImageView(plus));
            increasePriceLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    autoTrading.updatePrice((IWare)ware, 1);
                }
            });
            increasePriceLbl.visibleProperty().bind((ObservableValue)new VisibleTradeTypeBinding(autoTrading.tradingTypeProperty((IWare)ware)));
            row.add((ITableCell)new ControlTableCell((Node)increasePriceLbl));
            model.add(row);
        }
        return model;
    }

    private class HireActionBinding
    extends ObjectBinding<EventHandler<MouseEvent>> {
        private final ITradingOffice office;

        private HireActionBinding(ITradingOffice office) {
            this.office = office;
            super.bind(new Observable[]{office.storageManagerPresentBinding()});
        }

        protected EventHandler<MouseEvent> computeValue() {
            if (this.office.storageManagerPresentBinding().get()) {
                return new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        HireActionBinding.this.office.setSteward(null);
                        Table newModel = new Table();
                        AutomaticTradingOverviewDialog.this.setModel(newModel);
                    }
                };
            }
            return new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    HireActionBinding.this.office.setSteward((ISteward)new Steward());
                    Table newModel = AutomaticTradingOverviewDialog.this.createAutomaticTradingModel();
                    AutomaticTradingOverviewDialog.this.setModel(newModel);
                }
            };
        }
    }

    private static class HireButtonTextBinding
    extends StringBinding {
        private final ITradingOffice office;

        private HireButtonTextBinding(ITradingOffice office) {
            this.office = office;
            super.bind(new Observable[]{office.storageManagerPresentBinding()});
        }

        protected String computeValue() {
            if (this.office.storageManagerPresentBinding().get()) {
                return "Fire";
            }
            return "Hire";
        }
    }

    private class VisibleTradeTypeBinding
    extends BooleanBinding {
        private final ObjectProperty<ETradeType> boundTradeType;

        private VisibleTradeTypeBinding(ObjectProperty<ETradeType> boundTradeType) {
            this.boundTradeType = boundTradeType;
            super.bind(new Observable[]{boundTradeType});
        }

        protected boolean computeValue() {
            return this.boundTradeType.get() != ETradeType.NONE;
        }
    }

    private class TradingSwitchObjectBinding
    extends ObjectBinding<Image> {
        private final ObjectProperty<ETradeType> boundTradeType;

        TradingSwitchObjectBinding(ObjectProperty<ETradeType> tradeTypeProperty) {
            super.bind(new Observable[]{tradeTypeProperty});
            this.boundTradeType = tradeTypeProperty;
        }

        protected Image computeValue() {
            switch ((ETradeType)this.boundTradeType.get()) {
                case NONE: {
                    return AutomaticTradingOverviewDialog.this.imageLoader.getImage("waxseal", 62.0, 24.0);
                }
                case CITY_OFFICE: {
                    return AutomaticTradingOverviewDialog.this.imageLoader.getImage("townOutIcon", 62.0, 24.0);
                }
                case OFFICE_CITY: {
                    return AutomaticTradingOverviewDialog.this.imageLoader.getImage("townInIcon", 62.0, 24.0);
                }
            }
            throw new IllegalArgumentException("Illegal trading type: " + this.boundTradeType.get());
        }
    }
}

