/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.TabelViewDialog;
import ch.sahits.game.javafx.control.BaleAmount;
import ch.sahits.game.javafx.control.BarrelAmount;
import ch.sahits.game.javafx.control.PlaceHolder;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.city.BuildingProduction;
import ch.sahits.game.openpatrician.model.city.CityProduction;
import ch.sahits.game.openpatrician.model.city.EPopulationClass;
import ch.sahits.game.openpatrician.model.city.PopulationConsume;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.property.IntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
public class CityProductionConsumtionDialog
extends TabelViewDialog {
    protected final ICityPlayerProxyJFX city;
    private final Font font;
    @Autowired
    private CityProduction cityProduction;
    @Autowired
    private BuildingProduction buildingProduction;
    @Autowired
    private PopulationConsume consumer;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;

    public CityProductionConsumtionDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
    }

    @PostConstruct
    private void initializeModelAndDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityProductionConsumtionDialog.prodCon", new Object[0], this.locale.getCurrentLocal()));
        Group subTitle = this.createSubTitle();
        subTitle.setLayoutX(30.0);
        subTitle.setLayoutY(80.0);
        this.getContent().add((Object)subTitle);
        Table model = this.createModel();
        this.setModel(model);
    }

    private Group createSubTitle() {
        Group g = new Group();
        g.setManaged(false);
        Text text = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityProductionConsumtionDialog.weekly", new Object[0], this.locale.getCurrentLocal()));
        text.setFont(this.font);
        StackPane titlePane = new StackPane();
        titlePane.getChildren().addAll((Object[])new Node[]{new PlaceHolder(518.0, 1.0), text});
        g.getChildren().add((Object)titlePane);
        return g;
    }

    private Table createModel() {
        Table model = new Table();
        TableHeader header = new TableHeader(7);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ware", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityProductionConsumtionDialog.stock", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.city", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityProductionConsumtionDialog.shops", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityProductionConsumtionDialog.pop", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityProductionConsumtionDialog.shops", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityProductionConsumtionDialog.tot", new Object[0], this.locale.getCurrentLocal())));
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.RIGHT);
        model.setAligenment(3, HPos.RIGHT);
        model.setAligenment(4, HPos.RIGHT);
        model.setAligenment(5, HPos.RIGHT);
        model.setAligenment(6, HPos.RIGHT);
        model.setColumnWidth(new Integer[]{70, 60, 60, 60, 60, 60, 60});
        for (EWare ware : EWare.values()) {
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(ware)));
            IntegerProperty amountAvailableProp = this.city.getCity().getWare((IWare)ware).amountProperty();
            if (ware.isBarrelSizedWare()) {
                BarrelAmount barrelAmount = new BarrelAmount(this.font);
                barrelAmount.amountProperty().bind((ObservableValue)amountAvailableProp.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmount baleAmount = new BaleAmount(this.font);
                baleAmount.amountProperty().bind((ObservableValue)amountAvailableProp.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            int producedAmount = this.calculateProducedWares((IWare)ware);
            this.addAmountCell(ware, row, producedAmount);
            int chandlerPrdouction = this.buildingProduction.getTotalProduction((IWare)ware, this.city.getCity());
            this.addAmountCell(ware, row, chandlerPrdouction);
            int popConsumption = this.computeCitizenConsumtion((IWare)ware);
            this.addAmountCell(ware, row, popConsumption);
            int consumeShops = this.buildingProduction.getTotalConsumtion((IWare)ware, this.city.getCity());
            this.addAmountCell(ware, row, consumeShops);
            int consumeTot = consumeShops;
            this.addAmountCell(ware, row, consumeTot += this.computeCitizenConsumtion((IWare)ware));
            model.add(row);
        }
        return model;
    }

    private void addAmountCell(EWare ware, TableRow row, int popConsumption) {
        if (ware.isBarrelSizedWare()) {
            BarrelAmount barrelAmount = new BarrelAmount(this.font);
            barrelAmount.setAmount(Integer.valueOf(popConsumption));
            row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
        } else {
            BaleAmount baleAmount = new BaleAmount(this.font);
            baleAmount.setAmount(Integer.valueOf(popConsumption));
            row.add((ITableCell)new ControlTableCell((Node)baleAmount));
        }
    }

    private int calculateProducedWares(IWare ware) {
        IWare[] effective = this.city.getCity().getEffectiveProduction();
        IWare[] ineffective = this.city.getCity().getIneffectiveProduction();
        int amount = 0;
        if (this.contains(effective, ware)) {
            amount = this.cityProduction.getEfficientProduction(ware);
        } else if (this.contains(ineffective, ware)) {
            amount = this.cityProduction.getInefficientProduction(ware);
        }
        return amount;
    }

    private boolean contains(IWare[] array, IWare item) {
        for (IWare ware : array) {
            if (ware != item) continue;
            return true;
        }
        return false;
    }

    private int computeCitizenConsumtion(IWare ware) {
        double amount = this.consumer.getNeed(ware, EPopulationClass.POOR, this.city.getCity().getPopulation(EPopulationClass.POOR));
        amount += this.consumer.getNeed(ware, EPopulationClass.MEDIUM, this.city.getCity().getPopulation(EPopulationClass.MEDIUM));
        int value = (int)Math.rint(amount += this.consumer.getNeed(ware, EPopulationClass.RICH, this.city.getCity().getPopulation(EPopulationClass.RICH)));
        return value;
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
}

