/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.control.PlaceHolder;
import ch.sahits.game.openpatrician.dialog.Dialog;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class CloseButtonDialog
extends Dialog {
    @Autowired
    @Qualifier(value="clientEventBus")
    protected AsyncEventBus clientEventBus;
    private static final int CLOSE_BUTTON_HEIGHT = 24;
    private static final int CLOSE_BUTTON_WIDTH = 62;
    private static final int CLOSE_BUTTON_PADDING = 40;
    public static final int CLOSE_BTN_Y_POS = 627;
    private StringProperty title = new SimpleStringProperty((Object)this, "title", "");
    private StringProperty closeLabel = new SimpleStringProperty((Object)this, "closeLabel", "");

    public CloseButtonDialog(Font font) {
        super(font);
        Label titleLbl = new Label();
        titleLbl.getStyleClass().add((Object)"dialogTitle");
        titleLbl.textProperty().bind((ObservableValue)this.title);
        titleLbl.setFont(font);
        StackPane titlePane = new StackPane();
        titlePane.setLayoutY(30.0);
        titlePane.getChildren().addAll((Object[])new Node[]{new PlaceHolder(518.0, 1.0), titleLbl});
        this.getContent().add((Object)titlePane);
        OpenPatricianSmallWaxButton closeButton = new OpenPatricianSmallWaxButton("X", font);
        closeButton.setLayoutX(416.0);
        closeButton.setLayoutY(627.0);
        closeButton.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                CloseButtonDialog.this.executeOnCloseButtonClicked();
            }
        });
        closeButton.getStyleClass().add((Object)"buttonLabel");
        this.getContent().add((Object)closeButton);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public void removeDecoratedContent() {
        for (final Node child : this.getContent()) {
            if (!(child instanceof DecoratedText)) continue;
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    CloseButtonDialog.this.getContent().remove((Object)child);
                }
            });
        }
    }

    public StringProperty closeLabelProperty() {
        return this.closeLabel;
    }

    public String getCloseLabel() {
        return (String)this.closeLabel.get();
    }

    public void setCloseLabel(String closeLabel) {
        this.closeLabel.set((Object)closeLabel);
    }

    public void addButtomControlButtons(OpenPatricianSmallWaxButton ... buttons) {
        double availableSpace = 376.0;
        double widthButtonAndGap = availableSpace / (double)buttons.length;
        Preconditions.checkState((widthButtonAndGap >= 62.0 ? 1 : 0) != 0, (Object)"Cannot draw buttons as there is not enough space");
        double gap = widthButtonAndGap - 62.0;
        double x = 40.0;
        for (OpenPatricianSmallWaxButton btn : buttons) {
            btn.setLayoutX(x);
            btn.setLayoutY(627.0);
            x += 62.0 + gap;
            this.getContent().add((Object)btn);
        }
    }

    protected void executeOnCloseButtonClicked() {
        ViewChangeEvent event = new ViewChangeEvent(MainGameView.class, (Object)EViewChangeEvent.CLOSE_DIALOG);
        this.clientEventBus.post((Object)event);
    }
}

