/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.engine.land.city.LoanerEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.LoanerState;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.HashMap;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
public class LoanerListLoansDialog
extends CloseButtonDialog {
    private final int BUTTON_X = 197;
    private final int BUTTON_Y = 603;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private LoanerEngine loanerEngine;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private Date date;
    @Autowired
    private ClientViewState viewState;
    private LoanerState loaner;
    private final ICityPlayerProxyJFX city;
    private final Font font;

    public LoanerListLoansDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
    }

    @PostConstruct
    private void initializeDialog() {
        ICity city1 = this.city.getCity();
        this.loaner = (LoanerState)this.loanerEngine.getLoaner(city1);
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerListLoansDialog.title", new Object[0], this.locale.getCurrentLocal()));
        String header = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerListLoansDialog.subHeader", new Object[0], this.locale.getCurrentLocal());
        VBox box = new VBox(5.0);
        box.setLayoutX(30.0);
        box.setLayoutY(200.0);
        Text subHeading = new Text();
        subHeading.setText(header);
        subHeading.setFont(this.font);
        box.getChildren().add((Object)subHeading);
        String cityName = city1.getName();
        for (IDebt debt : this.loanerEngine.findLoans((ILoaner)this.loaner, this.city.getPlayer())) {
            ICitizen debitor = debt.getDebitor();
            String title = this.translator.getLocalDisplayName(debitor.getRank());
            int paybacksum = (int)(debt.getInterest() * (double)debt.getAmount());
            DateTime dueDate1 = debt.getDueDate();
            String dueDate = this.date.todisplayString(dueDate1.getDayOfMonth(), dueDate1.getMonthOfYear(), dueDate1.getYear());
            String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerListLoansDialog.outstandingLoan", new Object[]{title, debitor.getName(), debitor.getLastName(), cityName, paybacksum, dueDate}, this.locale.getCurrentLocal());
            DecoratedText entry = this.textFactory.createDecoratedText(s, new HashMap());
            box.getChildren().add((Object)entry);
        }
        this.getContent().addAll((Object[])new Node[]{box});
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX((ICityPlayerProxyJFX)this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_LOANER);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

