/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.engine.land.city.LoanerEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import ch.sahits.game.openpatrician.model.city.impl.Debt;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanerState;
import ch.sahits.game.openpatrician.model.impl.Citizen;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
public class LoanerTakeLoanDialog
extends CloseButtonDialog {
    private final int BUTTON_X = 197;
    private final int BUTTON_Y = 603;
    public static final String DEFAULT_NON_SELECTED_STYLE = "-fx-fill: dimgray; -fx-text-fill: dimgray;";
    public static final String SELECTED_STYLE = "-fx-font-weight: bolder; -fx-fill: black;  -fx-text-fill: black;";
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private LoanerEngine loanerEngine;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private ClientViewState viewState;
    private LoanerState loaner;
    private final ICityPlayerProxyJFX city;
    private final Font font;
    private static RandomNameLoader firstNameLoader = new RandomNameLoader("firstnames.properties");
    private static RandomNameLoader lastNameLoader = new RandomNameLoader("lastnames.properties");
    private ObjectProperty<ILoanProposal> selectedProposal = new SimpleObjectProperty(null);
    private VBox box;

    public LoanerTakeLoanDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
    }

    @PostConstruct
    private void initializeDialog() {
        this.loaner = (LoanerState)this.loanerEngine.getLoaner(this.city.getCity());
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.takeLoan", new Object[0], this.locale.getCurrentLocal()));
        String header = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerTakeLoanDialog.dialogSubheading", new Object[0], this.locale.getCurrentLocal());
        this.box = new VBox(5.0);
        this.box.setLayoutX(30.0);
        this.box.setLayoutY(200.0);
        Text subHeading = new Text();
        subHeading.setText(header);
        subHeading.setFont(this.font);
        this.box.getChildren().add((Object)subHeading);
        for (final ILoanProposal proposal : this.loaner.getLoanProposals()) {
            int amount = proposal.getAmount();
            int payback = (int)((double)amount * proposal.getInterest());
            int duration = proposal.getDurationInWeeks();
            String interest = String.format("%.1f", (proposal.getInterest() - 1.0) * 100.0);
            String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerTakeLoanDialog.loanProposal", new Object[]{amount, duration, payback, interest}, this.locale.getCurrentLocal());
            final DecoratedText entry = this.textFactory.createDecoratedText(s, new HashMap());
            entry.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    LoanerTakeLoanDialog.this.selectedProposal.setValue((Object)proposal);
                    LoanerTakeLoanDialog.this.deactivateAll();
                    entry.applyStyle(LoanerTakeLoanDialog.SELECTED_STYLE);
                }
            });
            entry.applyStyle(DEFAULT_NON_SELECTED_STYLE);
            this.box.getChildren().add((Object)entry);
        }
        final OpenPatricianLargeWaxButton acceptBtn = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerTakeLoanDialog.btnLabel", new Object[0], this.locale.getCurrentLocal()), this.font);
        acceptBtn.setLayoutX(197.0);
        acceptBtn.setLayoutY(603.0);
        acceptBtn.setDisable(true);
        this.selectedProposal.addListener((ChangeListener)new ChangeListener<ILoanProposal>(){

            public void changed(ObservableValue<? extends ILoanProposal> observableValue, ILoanProposal oldProposal, ILoanProposal newProposal) {
                if (newProposal != null) {
                    acceptBtn.setDisable(false);
                }
            }
        });
        acceptBtn.setOnAction(this.createAcceptHandler());
        this.getContent().addAll((Object[])new Node[]{this.box, acceptBtn});
    }

    private void deactivateAll() {
        for (Node node : this.box.getChildren()) {
            if (!(node instanceof DecoratedText)) continue;
            ((DecoratedText)node).applyStyle(DEFAULT_NON_SELECTED_STYLE);
        }
    }

    private EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                DateTime now = LoanerTakeLoanDialog.this.date.getCurrentDate();
                ILoanProposal proposal = (ILoanProposal)LoanerTakeLoanDialog.this.selectedProposal.get();
                IPlayer debitor = LoanerTakeLoanDialog.this.city.getPlayer();
                ESocialRank rank = ESocialRank.values()[LoanerTakeLoanDialog.this.rnd.nextInt(ESocialRank.values().length - 2)];
                Citizen creditor = new Citizen(lastNameLoader.getRandomName(), firstNameLoader.getRandomName(), rank, LoanerTakeLoanDialog.this.city.getCity());
                DateTime dueDate = now.plusWeeks(proposal.getDurationInWeeks());
                Debt debt = Debt.builder().creditor((ICreditor)creditor).amount(proposal.getAmount()).dueDate(dueDate).interest(proposal.getInterest()).debitor((ICitizen)debitor).build();
                LoanerTakeLoanDialog.this.loaner.addDebt((IDebt)debt);
                LoanerTakeLoanDialog.this.loaner.getLoanProposals().remove(proposal);
                debitor.getCompany().updateCash((long)proposal.getAmount());
                LoanerTakeLoanDialog.this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX((ICityPlayerProxyJFX)this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_LOANER);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

