/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.personal.EMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.personal.IMilitantCareer;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import ch.sahits.game.openpatrician.model.personal.IReputation;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
public class PersonalDialog
extends CloseButtonDialog {
    private Font font;
    protected final ICityPlayerProxyJFX city;
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ModelTranslations modelTranslator;

    public PersonalDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.font = font;
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.personal", new Object[0], this.locale.getCurrentLocal()));
        IPlayer player = this.city.getPlayer();
        IPersonalData personalData = player.getPersonalData();
        VBox box = new VBox();
        box.setLayoutX(30.0);
        box.setLayoutY(80.0);
        this.createAndAddNewText(box, this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.name", new Object[0], this.locale.getCurrentLocal()));
        StringBuilder sb = new StringBuilder();
        sb.append(personalData.getName()).append(" ").append(personalData.getLastName());
        ESocialRank rank = player.getRank();
        sb.append(" (").append(this.modelTranslator.getLocalDisplayName(player.getCareerLevel())).append(" ").append(this.modelTranslator.getLocalDisplayName(rank)).append(")");
        this.createAndAddNewText(box, sb.toString());
        box.getChildren().add((Object)this.createEmptyNode());
        this.createAndAddNewText(box, this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.born", new Object[0], this.locale.getCurrentLocal()));
        sb = new StringBuilder();
        ICity birthPlace = personalData.getBirthPlace();
        DateTime birthDate = personalData.getBirthDate();
        sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.on", new Object[0], this.locale.getCurrentLocal())).append(this.date.todisplayString(birthDate.getDayOfMonth(), birthDate.getMonthOfYear(), birthDate.getYear())).append(" in ").append(birthPlace.getName()).append(", ");
        sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.age", new Object[0], this.locale.getCurrentLocal())).append(personalData.getAge(this.date.getCurrentDate()));
        this.createAndAddNewText(box, sb.toString());
        box.getChildren().add((Object)this.createEmptyNode());
        this.createAndAddNewText(box, this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.hometown", new Object[0], this.locale.getCurrentLocal()));
        this.createAndAddNewText(box, player.getHometown().getName());
        box.getChildren().add((Object)this.createEmptyNode());
        sb = new StringBuilder();
        sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.socStatus", new Object[0], this.locale.getCurrentLocal())).append(this.city.getCity().getSocialRank());
        this.createAndAddNewText(box, sb.toString());
        this.createAndAddNewText(box, this.getReputationText(player));
        List<String> careerAdvice = this.getCareerAdvice(player);
        if (careerAdvice.isEmpty()) {
            box.getChildren().add((Object)this.createEmptyNode());
            box.getChildren().add((Object)this.createEmptyNode());
        } else {
            this.createAndAddNewText(box, careerAdvice.get(0));
            this.createAndAddNewText(box, careerAdvice.get(0));
        }
        this.createAndAddNewText(box, this.getUnderworldReputation(player));
        ISpouseData spouseData = player.getSpouseData();
        if (spouseData != null) {
            String s = spouseData.isMale() ? this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.husbandName", new Object[0], this.locale.getCurrentLocal()) : this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.wifeName", new Object[0], this.locale.getCurrentLocal());
            this.createAndAddNewText(box, s);
            sb = new StringBuilder();
            sb.append(spouseData.getName()).append(" ").append(spouseData.getLastName());
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.age2", new Object[0], this.locale.getCurrentLocal())).append(spouseData.getAge(this.date.getCurrentDate()));
            this.createAndAddNewText(box, sb.toString());
            box.getChildren().add((Object)this.createEmptyNode());
            this.createAndAddNewText(box, this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.born", new Object[0], this.locale.getCurrentLocal()));
            sb = new StringBuilder();
            birthDate = spouseData.getBirthDate();
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.on", new Object[0], this.locale.getCurrentLocal())).append(this.date.todisplayString(birthDate.getDayOfMonth(), birthDate.getMonthOfYear(), birthDate.getYear())).append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.in", new Object[0], this.locale.getCurrentLocal())).append(spouseData.getBirthPlace().getName());
            this.createAndAddNewText(box, sb.toString());
            this.createAndAddNewText(box, this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.children", new Object[0], this.locale.getCurrentLocal()));
            this.createAndAddNewText(box, String.valueOf(spouseData.getNumberOfChildren()));
            List<String> spouseReputation = this.getSpouseReputation(player, spouseData);
            this.createAndAddNewText(box, spouseReputation.get(0));
            this.createAndAddNewText(box, spouseReputation.get(1));
        }
        this.getContent().add((Object)box);
    }

    private void createAndAddNewText(VBox box, String s) {
        Text spouseName = new Text(s);
        spouseName.setFont(this.font);
        box.getChildren().add((Object)spouseName);
    }

    private Node createEmptyNode() {
        Text text = new Text("");
        text.setFont(this.font);
        return text;
    }

    private String getReputationText(IPlayer player) {
        IReputation rep = this.city.getCity().getReputation(player);
        int repDiff = rep.getReputationDifference();
        StringBuilder sb = new StringBuilder();
        if (repDiff < 0) {
            if (repDiff <= -10 && repDiff > -25) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.sunkenRep1", new Object[0], this.locale.getCurrentLocal()));
            } else if (repDiff > -10) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.sunkenRep2", new Object[0], this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.sunkenRep3", new Object[0], this.locale.getCurrentLocal()));
            }
        } else if (repDiff > 0) {
            if (repDiff >= 10 && repDiff < 25) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.risenRep1", new Object[0], this.locale.getCurrentLocal()));
            } else if (repDiff < 10) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.risenRep2", new Object[0], this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.risenRep3", new Object[0], this.locale.getCurrentLocal()));
            }
        } else {
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.unchangedRep", new Object[0], this.locale.getCurrentLocal()));
        }
        return sb.toString();
    }

    private List<String> getCareerAdvice(IPlayer player) {
        ESocialRank rank = player.getRank();
        ArrayList<String> lines = new ArrayList<String>();
        if (rank != ESocialRank.ALDERMAN && rank != ESocialRank.MAYOR) {
            ESocialRank nextRank = rank.getNextRank();
            boolean needFortune = false;
            if (player.getCompany().getCompanyValue() < (long)nextRank.getCompanyValue()) {
                needFortune = true;
            }
            boolean needReputation = false;
            if (this.city.getCity().getReputation(player).getPopularity() < nextRank.getSocialReputation()) {
                needReputation = true;
            }
            StringBuilder sb = new StringBuilder();
            if (needFortune && needReputation) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice1_1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
                lines.add(sb.toString());
                sb = new StringBuilder();
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice1_2", new Object[0], this.locale.getCurrentLocal()));
                lines.add(sb.toString());
            } else if (needFortune) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice2_1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
                lines.add(sb.toString());
                sb = new StringBuilder();
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice1_2", new Object[0], this.locale.getCurrentLocal()));
                lines.add(sb.toString());
            } else if (needReputation) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice3_1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
                lines.add(sb.toString());
                sb = new StringBuilder();
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.careerAdvice1_2", new Object[0], this.locale.getCurrentLocal()));
                lines.add(sb.toString());
            }
        }
        return lines;
    }

    public List<String> getSpouseReputation(IPlayer player, ISpouseData spouse) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        if (this.city.getCity() == spouse.getBirthPlace()) {
            if (spouse.isMale()) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep2", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            }
            lines.add(sb.toString());
            sb = new StringBuilder();
            lines.add(sb.toString());
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep3", new Object[0], this.locale.getCurrentLocal()));
        } else if (this.city.getCity() == player.getCompany().getHomeTown()) {
            if (spouse.isMale()) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep2", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            }
            lines.add(sb.toString());
            sb = new StringBuilder();
            lines.add(sb.toString());
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep3", new Object[0], this.locale.getCurrentLocal()));
        } else {
            if (spouse.isMale()) {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep1", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            } else {
                sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep2", new Object[]{this.city.getCity().getName()}, this.locale.getCurrentLocal()));
            }
            lines.add(sb.toString());
            sb = new StringBuilder();
            lines.add(sb.toString());
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.spouseRep3", new Object[0], this.locale.getCurrentLocal()));
        }
        return lines;
    }

    private String getUnderworldReputation(IPlayer player) {
        ICareer careerLevel = player.getCareerLevel();
        String s = careerLevel instanceof IMilitantCareer ? ((EMilitantCareer)careerLevel != EMilitantCareer.BOISTEROUS && (EMilitantCareer)careerLevel != EMilitantCareer.BOLD ? this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.underworldRep1", new Object[0], this.locale.getCurrentLocal()) : this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.underworldRep2", new Object[0], this.locale.getCurrentLocal())) : this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.underworldRep2", new Object[0], this.locale.getCurrentLocal());
        return s;
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
}

