/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.data.ShipyardOrderRefit;
import ch.sahits.game.graphic.display.dialog.BaseShipyardDialog;
import ch.sahits.game.javafx.control.BaleAmountAlwaysVisible;
import ch.sahits.game.javafx.control.BarrelAmount;
import ch.sahits.game.javafx.control.BarrelAmountAlwaysVisible;
import ch.sahits.game.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ECellConstraint;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.IShipWeaponsLocation;
import ch.sahits.game.openpatrician.model.ship.ShipFactory;
import ch.sahits.game.openpatrician.model.ship.impl.ShipWeaponsLocationFactory;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shipyardUpgradeDialog")
@Scope(value="prototype")
public class ShipyardUpgradeDialogV2
extends BaseShipyardDialog {
    private ObjectProperty<IShip> currentShip;
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private ShipWeaponsLocationFactory weaponsLocationFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    private static final EWare[] MATERIALS = new EWare[]{EWare.WOOD, EWare.IRON, EWare.PITCH};
    private HashMap<IWare, IntegerProperty> availableMap = new HashMap();
    private HashMap<IWare, IntegerBinding> priceMap = new HashMap();
    private HashMap<IWare, BaseShipyardDialog.BuyAmountBinding> buyAmountMap = new HashMap();

    public ShipyardUpgradeDialogV2(Font font, final ICityPlayerProxyJFX city) {
        super(font, city);
        this.currentShip = new SimpleObjectProperty((Object)this, "currentShip", (Object)city.getActiveShip());
        this.enablePreviousNext = new BooleanBinding(){
            {
                super.bind(new Observable[]{city.getPlayersShips()});
            }

            protected boolean computeValue() {
                return city.getPlayersShips().size() > 1;
            }
        };
        for (int i = 0; i < this.shipTypes.length; ++i) {
            if (this.shipTypes[i] != ((IShip)this.currentShip.get()).getShipType()) continue;
            this.currentShipTypeIndexProperty().set(i);
            break;
        }
        this.mainTableYPosition = 334;
    }

    @PostConstruct
    private void intializeAdditionalText() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.title", new Object[0], this.locale.getCurrentLocal()));
        final Text name = new Text();
        name.setFont(this.font);
        name.setLayoutX(50.0);
        name.setLayoutY(286.0);
        name.setText(((IShip)this.currentShip.get()).getName());
        this.currentShip.addListener((ChangeListener)new ChangeListener<IShip>(){

            public void changed(ObservableValue<? extends IShip> observableValue, IShip oldValue, IShip newValue) {
                name.setText(newValue.getName());
            }
        });
        final Text level = new Text();
        level.setFont(this.font);
        level.setLayoutX(50.0);
        level.setLayoutY(310.0);
        level.setText(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardUpgradeDialogV2.upgradeLevel", new Object[]{((IShip)this.currentShip.get()).getShipUpgradeLevel().nextLevel().name()}, this.locale.getCurrentLocal()));
        this.currentShip.addListener((ChangeListener)new ChangeListener<IShip>(){

            public void changed(ObservableValue<? extends IShip> observableValue, IShip oldValue, IShip newValue) {
                level.setText(ShipyardUpgradeDialogV2.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardUpgradeDialogV2.upgradeLevel", new Object[]{newValue.getShipUpgradeLevel().nextLevel().name()}, ShipyardUpgradeDialogV2.this.locale.getCurrentLocal()));
            }
        });
        this.getContent().addAll((Object[])new Node[]{name, level});
    }

    @Override
    protected boolean hasShips() {
        return this.city.getPlayersShips().size() > 0;
    }

    @Override
    protected EventHandler<MouseEvent> getAction() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ITradingOffice office = ShipyardUpgradeDialogV2.this.getPlayer().findTradingOffice(ShipyardUpgradeDialogV2.this.getCity());
                for (EWare ware : MATERIALS) {
                    int buyAmount = ((BaseShipyardDialog.BuyAmountBinding)((Object)ShipyardUpgradeDialogV2.this.buyAmountMap.get(ware))).get();
                    ShipyardUpgradeDialogV2.this.getCity().move((IWare)ware, -buyAmount, ShipyardUpgradeDialogV2.this.getPlayer());
                    int needed = ShipyardUpgradeDialogV2.this.shipFactory.getUpgradeAmount(((IShip)ShipyardUpgradeDialogV2.this.currentShip.get()).getShipType(), ware);
                    int fromWarhouse = needed - buyAmount;
                    office.move((IWare)ware, -fromWarhouse);
                }
                ShipyardOrderRefit event = new ShipyardOrderRefit(ShipyardUpgradeDialogV2.this.getCity().getCityState().getShipyardState(), (IShip)ShipyardUpgradeDialogV2.this.currentShip.get(), ((IShip)ShipyardUpgradeDialogV2.this.currentShip.get()).getShipUpgradeLevel().nextLevel());
                ShipyardUpgradeDialogV2.this.clientServerEventBus.post((Object)event);
                ShipyardUpgradeDialogV2.this.city.getPlayersShips().remove(ShipyardUpgradeDialogV2.this.currentShip.get());
                ShipyardUpgradeDialogV2.this.getPlayer().getCompany().updateCash((long)(-ShipyardUpgradeDialogV2.this.calculateTotalUpgradeCosts()));
                ShipyardUpgradeDialogV2.this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected String getActionText() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardUpgradeDialogV2.refit", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected Group createFooterText() {
        IntegerBinding totalPriceBinding = new IntegerBinding(){
            {
                for (EWare ware : MATERIALS) {
                    super.bind(new Observable[]{ShipyardUpgradeDialogV2.this.getPriceBinding((IWare)ware, null)});
                }
            }

            protected int computeValue() {
                return ShipyardUpgradeDialogV2.this.calculateTotalUpgradeCosts();
            }
        };
        Group g = new Group();
        Label t = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.totalSum", new Object[0], this.locale.getCurrentLocal()));
        t.setFont(this.font);
        g.getChildren().add((Object)t);
        CoinPriceAlwaysVisible price = new CoinPriceAlwaysVisible(this.font);
        price.amountProperty().bind((ObservableValue)totalPriceBinding.asString());
        price.layoutXProperty().bind((ObservableValue)t.widthProperty());
        g.getChildren().add((Object)price);
        return g;
    }

    private int calculateTotalUpgradeCosts() {
        int total = this.getCity().getCityState().getShipyardState().calculateRefitCosts(((IShip)this.currentShip.get()).getShipType(), 1);
        for (EWare ware : MATERIALS) {
            total += this.getPriceBinding((IWare)ware, null).get();
        }
        return total;
    }

    @Override
    protected Table createMainTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.materials", new Object[0], this.locale.getCurrentLocal())), ECellConstraint.COLSPAN2);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.stored", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.buy", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.costs", new Object[0], this.locale.getCurrentLocal())));
        header.setAligenment(0, HPos.CENTER);
        header.setAligenment(2, HPos.CENTER);
        header.setAligenment(3, HPos.CENTER);
        header.setAligenment(4, HPos.CENTER);
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.RIGHT);
        model.setAligenment(3, HPos.RIGHT);
        model.setAligenment(4, HPos.RIGHT);
        model.setColumnWidth(new Integer[]{70, 70, 70, 70, 100});
        for (EWare ware : MATERIALS) {
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(ware)));
            IntegerBinding needed = this.getNeededWareBinding(ware);
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible(this.font);
                barrelAmount.amountProperty().bind((ObservableValue)needed.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible(this.font);
                baleAmount.amountProperty().bind((ObservableValue)needed.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            IntegerProperty stored = this.getStoredAmount((IWare)ware);
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible(this.font);
                barrelAmount.amountProperty().bind((ObservableValue)stored.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible(this.font);
                baleAmount.amountProperty().bind((ObservableValue)stored.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            BaseShipyardDialog.BuyAmountBinding buyAmount = new BaseShipyardDialog.BuyAmountBinding((IWare)ware, needed);
            this.buyAmountMap.put((IWare)ware, buyAmount);
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible(this.font);
                barrelAmount.amountProperty().bind((ObservableValue)buyAmount.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible(this.font);
                baleAmount.amountProperty().bind((ObservableValue)buyAmount.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            IntegerBinding priceBinding = this.getPriceBinding((IWare)ware, buyAmount);
            CoinPriceAlwaysVisible price = new CoinPriceAlwaysVisible(this.font);
            price.amountProperty().bind((ObservableValue)priceBinding.asString());
            row.add((ITableCell)new ControlTableCell((Node)price));
            model.add(row);
        }
        return model;
    }

    private IntegerProperty getStoredAmount(IWare ware) {
        if (!this.availableMap.containsKey(ware)) {
            ITradingOffice office = this.getPlayer().findTradingOffice(this.getCity());
            IntegerProperty stored = office.getWare(ware).amountProperty();
            this.availableMap.put(ware, stored);
        }
        return this.availableMap.get(ware);
    }

    private IntegerBinding getPriceBinding(IWare ware, BaseShipyardDialog.BuyAmountBinding buyAmount) {
        if (!this.priceMap.containsKey(ware)) {
            BaseShipyardDialog.PriceBinding priceBinding = new BaseShipyardDialog.PriceBinding(ware, buyAmount);
            this.priceMap.put(ware, priceBinding);
        }
        return this.priceMap.get(ware);
    }

    private IntegerBinding getNeededWareBinding(final EWare ware) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{ShipyardUpgradeDialogV2.this.currentShipTypeIndexProperty()});
            }

            protected int computeValue() {
                return ShipyardUpgradeDialogV2.this.shipFactory.getConstructionAmount(ShipyardUpgradeDialogV2.this.getCurrentShipType(), ware);
            }
        };
    }

    @Override
    protected Table createTopTable() {
        int capacity = this.shipFactory.calculateInitialCapacity(this.getCurrentShipType(), this.getCity().getCoordinates().getX());
        IShipWeaponsLocation shipWeapons = this.weaponsLocationFactory.getShipWeaponsLocation(this.getCurrentShipType(), EShipUpgrade.NONE);
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{70, 70, 70, 70, 70});
        TableRow row = new TableRow();
        BarrelAmount capacityAmount = new BarrelAmount(this.font);
        capacityAmount.setAmount(Integer.valueOf(capacity));
        row.add((ITableCell)new ControlTableCell((Node)capacityAmount));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(shipWeapons.getNumberOfSmallSlots())));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(shipWeapons.getNumberOfLargeSlots())));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(this.shipFactory.getShipSpeed(this.getCurrentShipType()))));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(this.shipFactory.getMinimalSailors(this.getCurrentShipType()))));
        model.add(row);
        return model;
    }

    @Override
    protected BooleanBinding actionEnabledBinding() {
        return new BooleanBinding(){
            {
                for (EWare ware : MATERIALS) {
                    IntegerProperty stored = ShipyardUpgradeDialogV2.this.getStoredAmount((IWare)ware);
                    IntegerBinding price = ShipyardUpgradeDialogV2.this.getPriceBinding((IWare)ware, null);
                    IntegerProperty available = ShipyardUpgradeDialogV2.this.getCity().getWare((IWare)ware).amountProperty();
                    super.bind(new Observable[]{stored, price, available});
                }
                super.bind(new Observable[]{ShipyardUpgradeDialogV2.this.getPlayer().getCompany().cashProperty()});
            }

            protected boolean computeValue() {
                long buildCosts;
                long cash = ShipyardUpgradeDialogV2.this.getPlayer().getCompany().getCash();
                if (cash < (buildCosts = (long)ShipyardUpgradeDialogV2.this.calculateTotalUpgradeCosts())) {
                    return false;
                }
                for (EWare ware : MATERIALS) {
                    int storedAmount = ShipyardUpgradeDialogV2.this.getStoredAmount((IWare)ware).get();
                    int available = ShipyardUpgradeDialogV2.this.getCity().getWare((IWare)ware).getAmount();
                    int needed = ShipyardUpgradeDialogV2.this.shipFactory.getUpgradeAmount(((IShip)ShipyardUpgradeDialogV2.this.currentShip.get()).getShipType(), ware);
                    if (needed <= storedAmount + available) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    protected EventHandler<MouseEvent> createNextAction() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ObservableList ships = ShipyardUpgradeDialogV2.this.city.getPlayersShips();
                if (ships.size() > 1) {
                    if (((IShip)ships.get(ships.size() - 1)).equals(ShipyardUpgradeDialogV2.this.currentShip)) {
                        ShipyardUpgradeDialogV2.this.currentShip.set(ships.get(0));
                    } else {
                        for (int i = 0; i < ships.size() - 1; ++i) {
                            if (!((IShip)ships.get(i)).equals(ShipyardUpgradeDialogV2.this.currentShip)) continue;
                            ShipyardUpgradeDialogV2.this.currentShip.set(ships.get(i + 1));
                            break;
                        }
                    }
                }
            }
        };
    }

    @Override
    protected EventHandler<MouseEvent> createPreviousAction() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ObservableList ships = ShipyardUpgradeDialogV2.this.city.getPlayersShips();
                if (ships.size() > 1) {
                    if (((IShip)ships.get(0)).equals(ShipyardUpgradeDialogV2.this.currentShip)) {
                        ShipyardUpgradeDialogV2.this.currentShip.set(ships.get(ships.size() - 1));
                    } else {
                        for (int i = 1; i < ships.size(); ++i) {
                            if (!((IShip)ships.get(i)).equals(ShipyardUpgradeDialogV2.this.currentShip)) continue;
                            ShipyardUpgradeDialogV2.this.currentShip.set(ships.get(i - 1));
                            break;
                        }
                    }
                }
            }
        };
    }
}

