/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.TabelViewDialog;
import ch.sahits.game.graphic.image.impl.XMLImageLoader;
import ch.sahits.game.javafx.control.BaleIconView;
import ch.sahits.game.javafx.control.BarrelIconView;
import ch.sahits.game.javafx.control.CoinIconView;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ELevel;
import ch.sahits.game.openpatrician.model.building.IStorage;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
public class StorageOverviewDialog
extends TabelViewDialog {
    protected final ICityPlayerProxyJFX city;
    private final Font font;
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private XMLImageLoader imageLoader;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public StorageOverviewDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }

    @PostConstruct
    private void initializeModelAndDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog.storage", new Object[0], this.locale.getCurrentLocal()));
        Table model = this.createModel();
        this.setModel(model);
    }

    private Table createModel() {
        final ITradingOffice office = this.city.getPlayer().findTradingOffice(this.city.getCity());
        final IStorage storage = office.getStorage();
        Table model = new Table();
        TableHeader header = new TableHeader(4);
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        model.setHeader(header);
        model.setAligenment(0, HPos.LEFT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.RIGHT);
        model.setAligenment(3, HPos.LEFT);
        model.setColumnWidth(new Integer[]{210, 120, 30, 30});
        TableRow row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.requiredCapacity", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        Text amount = new Text();
        amount.setFont(this.font);
        amount.textProperty().bind((ObservableValue)office.storedAmountBinding().divide(10).asString());
        row.add((ITableCell)new ControlTableCell((Node)amount));
        BaleIconView baleAmount = new BaleIconView();
        row.add((ITableCell)new ControlTableCell((Node)baleAmount));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.availableCap", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        Text capacityTxt = new Text();
        capacityTxt.setFont(this.font);
        capacityTxt.textProperty().bind((ObservableValue)office.capacityProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)capacityTxt));
        baleAmount = new BaleIconView();
        row.add((ITableCell)new ControlTableCell((Node)baleAmount));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.additionalCap", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        IntegerBinding additionalAmount = new IntegerBinding(){
            {
                super.bind(new Observable[]{office.storedAmountBinding(), office.capacityProperty()});
            }

            protected int computeValue() {
                return Math.max(office.storedAmountBinding().subtract((ObservableNumberValue)office.capacityProperty()).intValue(), 0);
            }
        };
        Text additionalAmountTxt = new Text();
        additionalAmountTxt.setFont(this.font);
        additionalAmountTxt.textProperty().bind((ObservableValue)additionalAmount.asString());
        row.add((ITableCell)new ControlTableCell((Node)additionalAmountTxt));
        baleAmount = new BaleIconView();
        row.add((ITableCell)new ControlTableCell((Node)baleAmount));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.otherGoods", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        Text otherTxt = new Text();
        otherTxt.setFont(this.font);
        otherTxt.textProperty().bind((ObservableValue)storage.rentOutStorageProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)otherTxt));
        BarrelIconView barrelAmount = new BarrelIconView();
        row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.costs", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        Text storageCosts = new Text();
        storageCosts.setFont(this.font);
        storageCosts.textProperty().bind((ObservableValue)storage.costsPerDayBinding().asString());
        row.add((ITableCell)new ControlTableCell((Node)storageCosts));
        CoinIconView coinAmount = new CoinIconView();
        row.add((ITableCell)new ControlTableCell((Node)coinAmount));
        model.add(row);
        this.addEmptyRow(model);
        this.addEmptyRow(model);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.guards", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.noGuards", new Object[0], this.locale.getCurrentLocal())));
        Image minus = this.imageLoader.getImage("minusIcon");
        ImageView minusView = new ImageView(minus);
        Label minusLbl = new Label("", (Node)minusView);
        minusLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                storage.updateGuardsNumber(-1);
            }
        });
        row.add((ITableCell)new ControlTableCell((Node)minusLbl));
        Text nbGuardsTxt = new Text();
        nbGuardsTxt.setFont(this.font);
        nbGuardsTxt.textProperty().bind((ObservableValue)storage.numberGuardsProperty().asString());
        row.add((ITableCell)new ControlTableCell((Node)nbGuardsTxt));
        Image plus = this.imageLoader.getImage("plusIcon");
        ImageView plusView = new ImageView(plus);
        Label plusLbl = new Label("", (Node)plusView);
        plusLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                storage.updateGuardsNumber(1);
            }
        });
        row.add((ITableCell)new ControlTableCell((Node)plusLbl));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.costs", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        Text guardsCosts = new Text();
        guardsCosts.setFont(this.font);
        guardsCosts.textProperty().bind((ObservableValue)storage.guardCostsPerDayBinding().asString());
        row.add((ITableCell)new ControlTableCell((Node)guardsCosts));
        coinAmount = new CoinIconView();
        row.add((ITableCell)new ControlTableCell((Node)coinAmount));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.security", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        Text securityTxt = new Text();
        securityTxt.setFont(this.font);
        securityTxt.textProperty().bind((ObservableValue)new LevelBinding((ObjectBinding<ELevel>)storage.securityLevelBinding()));
        row.add((ITableCell)new ControlTableCell((Node)securityTxt));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
        return model;
    }

    private void addEmptyRow(Table model) {
        TableRow row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
    }

    private static class LevelBinding
    extends StringBinding {
        private final ObjectBinding<ELevel> levelBinding;

        LevelBinding(ObjectBinding<ELevel> levelBinding) {
            this.levelBinding = levelBinding;
            super.bind(new Observable[]{levelBinding});
        }

        protected String computeValue() {
            return ((ELevel)this.levelBinding.get()).name();
        }
    }
}

