/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.TavernDialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.people.ICourier;
import ch.sahits.game.openpatrician.model.people.IEscorte;
import ch.sahits.game.openpatrician.model.people.IFugitive;
import ch.sahits.game.openpatrician.model.people.IPatrol;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ISmuggler;
import ch.sahits.game.openpatrician.model.people.IThieve;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

public abstract class TavernBaseSideRoomPersonDialog
extends CloseButtonDialog {
    protected final ICityPlayerProxyJFX city;
    protected final Font font;
    private final TavernState tavernState;
    protected final ObjectProperty<ISideRoomPerson> currentPerson;
    @Autowired
    protected Date date;
    @Autowired
    protected TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    protected Locale locale;
    @Autowired
    protected MessageSource messageSource;
    private final int BUTTON_X = 197;
    private final int LOWER_BUTTON_Y = 603;
    private final int UPPER_BUTTON_Y = 579;
    private OpenPatricianLargeWaxButton acceptBtn;

    public TavernBaseSideRoomPersonDialog(Font font, ICityPlayerProxyJFX city, ISideRoomPerson person) {
        super(font);
        this.city = city;
        this.font = font;
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.currentPerson = new SimpleObjectProperty((Object)this, "currentPerson", (Object)person);
    }

    protected final void initializeButtons() {
        final BooleanBinding hasMorePersons = this.hasNextPersonBinding();
        this.acceptBtn = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[0], this.locale.getCurrentLocal()), this.font);
        this.acceptBtn.setLayoutX(197.0);
        this.acceptBtn.setOnAction(this.createAcceptHandler());
        OpenPatricianLargeWaxButton nextBtn = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.next", new Object[0], this.locale.getCurrentLocal()), this.font);
        nextBtn.setLayoutX(197.0);
        nextBtn.setLayoutY(603.0);
        nextBtn.setOnAction(this.createNextPersonHander());
        nextBtn.visibleProperty().bind((ObservableValue)hasMorePersons);
        this.acceptBtn.layoutYProperty().bind((ObservableValue)new DoubleBinding(){
            {
                super.bind(new Observable[]{hasMorePersons});
            }

            protected double computeValue() {
                if (hasMorePersons.get()) {
                    return 579.0;
                }
                return 603.0;
            }
        });
        BooleanBinding disableAcceptButton = this.disableAcceptButton();
        this.acceptBtn.setDisable(disableAcceptButton.get());
        disableAcceptButton.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                TavernBaseSideRoomPersonDialog.this.acceptBtn.setDisable(newValue.booleanValue());
            }
        });
        this.getContent().addAll((Object[])new Node[]{nextBtn, this.acceptBtn});
    }

    protected void removeAcceptButton() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TavernBaseSideRoomPersonDialog.this.getContent().remove((Object)TavernBaseSideRoomPersonDialog.this.acceptBtn);
            }
        });
    }

    protected abstract EventHandler<MouseEvent> createAcceptHandler();

    private EventHandler<MouseEvent> createNextPersonHander() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ((ObservableMap)TavernBaseSideRoomPersonDialog.this.tavernState.talkingToProperty().get()).remove(TavernBaseSideRoomPersonDialog.this.currentPerson.get());
                List persons = (List)TavernBaseSideRoomPersonDialog.this.tavernState.presentPersonsInSideRoomBinding().get();
                for (int i = 0; i < persons.size(); ++i) {
                    ISideRoomPerson person = (ISideRoomPerson)persons.get(i);
                    if (!person.equals(TavernBaseSideRoomPersonDialog.this.currentPerson.get())) continue;
                    if (i == persons.size() - 1) {
                        TavernBaseSideRoomPersonDialog.this.currentPerson.set(persons.get(0));
                        break;
                    }
                    TavernBaseSideRoomPersonDialog.this.currentPerson.set(persons.get(i + 1));
                    break;
                }
                ((ObservableMap)TavernBaseSideRoomPersonDialog.this.tavernState.talkingToProperty().get()).put(TavernBaseSideRoomPersonDialog.this.currentPerson.get(), (Object)TavernBaseSideRoomPersonDialog.this.city.getPlayer());
                ENoticeItem nextPerson = TavernBaseSideRoomPersonDialog.this.map((ISideRoomPerson)TavernBaseSideRoomPersonDialog.this.currentPerson.get());
                TavernBaseSideRoomPersonDialog.this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)nextPerson));
            }
        };
    }

    private BooleanBinding hasNextPersonBinding() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return ((List)TavernBaseSideRoomPersonDialog.this.tavernState.presentPersonsInSideRoomBinding().get()).size() > 1;
            }
        };
    }

    private ENoticeItem map(ISideRoomPerson person) {
        if (person instanceof ITransportTrader) {
            return ENoticeItem.TAVERN_TRANSPORT_TRADER;
        }
        if (person instanceof IBuyer) {
            return ENoticeItem.TAVERN_BUYER;
        }
        if (person instanceof IEscorte) {
            return ENoticeItem.TAVERN_ESCORTE;
        }
        if (person instanceof IFugitive) {
            return ENoticeItem.TAVERN_FUGATIVE;
        }
        if (person instanceof ICourier) {
            return ENoticeItem.TAVERN_COURIER;
        }
        if (person instanceof IPatrol) {
            return ENoticeItem.TAVERN_PATROL;
        }
        if (person instanceof IThieve) {
            return ENoticeItem.TAVERN_BURGLAR;
        }
        if (person instanceof IConcurrent) {
            return ENoticeItem.TAVERN_CONCURRENT;
        }
        if (person instanceof IPirateHunter) {
            return ENoticeItem.TAVERN_PIRATE_HUNTER;
        }
        if (person instanceof IWarehouseTenant) {
            return ENoticeItem.TAVERN_WAREHOUSE_TENANT;
        }
        if (person instanceof ISmuggler) {
            return ENoticeItem.TAVERN_SMUGGLER;
        }
        if (person instanceof ITreasureMapOwner) {
            return ENoticeItem.TAVERN_TREASUREMAP_OWNER;
        }
        throw new RuntimeException("Unhandled side room person: " + person.getClass().getName());
    }

    protected abstract BooleanBinding disableAcceptButton();

    @Override
    protected void executeOnCloseButtonClicked() {
        this.tavernDialogUtil.stopTalkingToPerson(this.tavernState, this.city.getPlayer());
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX((ICityPlayerProxyJFX)this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

