/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.impl.ThieveState;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class TavernBurglarDialog
extends TavernBaseSideRoomPersonDialog {
    public static final String DEFAULT_NON_SELECTED_STYLE = "-fx-fill: dimgray;";
    public static final String SELECTED_STYLE = "-fx-font-weight: bolder; -fx-fill: black;";
    private final List<IPlayer> residentOponents = Lists.newArrayList();
    private ObjectProperty<IPlayer> selectedOponent = new SimpleObjectProperty((Object)this, "selectedOpponent", null);
    @Autowired
    private Random rnd;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private ClientTaskFactory taskFactory;
    private BooleanBinding disabeAcceptBinding;
    @Autowired
    private ModelTranslations modelTranslator;

    public TavernBurglarDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getThieve());
        for (IPlayer player : city.getCity().getResidentPlayers()) {
            if (player.equals(city.getPlayer())) continue;
            this.residentOponents.add(player);
        }
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBurglarDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        VBox box = new VBox();
        box.setLayoutX(30.0);
        box.setLayoutY(100.0);
        Text intro = new Text();
        intro.setFont(this.font);
        StringBuilder sb = new StringBuilder();
        sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBurglarDialog.dialog1", new Object[0], this.locale.getCurrentLocal()));
        intro.setText(sb.toString());
        Text emptyLine = new Text(" ");
        emptyLine.setFont(this.font);
        box.getChildren().addAll((Object[])new Node[]{intro, emptyLine});
        ArrayList opponents = Lists.newArrayList();
        for (IPlayer opponent : this.residentOponents) {
            sb = new StringBuilder();
            sb.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBurglarDialog.list", new Object[]{this.modelTranslator.getLocalDisplayName(opponent.getCareerLevel()), this.modelTranslator.getLocalDisplayName(opponent.getRank()), opponent.getName(), opponent.getLastName(), opponent.getHometown().getName()}, this.locale.getCurrentLocal()));
            Text text = new Text(sb.toString());
            text.setFont(this.font);
            text.setUserData((Object)opponent);
            text.setStyle(DEFAULT_NON_SELECTED_STYLE);
            box.getChildren().add((Object)text);
            opponents.add(text);
        }
        for (IPlayer opponent : opponents) {
            opponent.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>((Text)opponent, (List)opponents){
                final /* synthetic */ Text val$opponent;
                final /* synthetic */ List val$opponents;
                {
                    this.val$opponent = text;
                    this.val$opponents = list;
                }

                public void handle(MouseEvent mouseEvent) {
                    TavernBurglarDialog.this.selectedOponent.set((Object)((IPlayer)this.val$opponent.getUserData()));
                    TavernBurglarDialog.this.disableAcceptButton().invalidate();
                    TavernBurglarDialog.this.resetStyles(this.val$opponents);
                    this.val$opponent.setStyle(TavernBurglarDialog.SELECTED_STYLE);
                }
            });
        }
        this.getContent().add((Object)box);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                IPlayer player = TavernBurglarDialog.this.city.getPlayer();
                ThieveState burglar = (ThieveState)TavernBurglarDialog.this.currentPerson.get();
                player.getCompany().updateCash((long)(-burglar.getPrice()));
                int probability = TavernBurglarDialog.this.rnd.nextInt(3);
                if (probability < 1) {
                    TavernBurglarDialog.this.timedTaskListener.add((TimedTask)TavernBurglarDialog.this.taskFactory.getDelayedCaughtAction(player));
                } else {
                    TavernBurglarDialog.this.timedTaskListener.add((TimedTask)TavernBurglarDialog.this.taskFactory.getBreakInAction((IPlayer)TavernBurglarDialog.this.selectedOponent.get()));
                }
                burglar.leave();
                TavernBurglarDialog.this.executeOnCloseButtonClicked();
            }
        };
    }

    private void resetStyles(List<Text> texts) {
        for (Text text : texts) {
            text.setStyle(DEFAULT_NON_SELECTED_STYLE);
        }
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        if (this.disabeAcceptBinding == null) {
            this.disabeAcceptBinding = new BooleanBinding(){

                protected boolean computeValue() {
                    return !TavernBurglarDialog.this.residentOponents.isEmpty() && TavernBurglarDialog.this.selectedOponent.get() == null;
                }
            };
        }
        return this.disabeAcceptBinding;
    }
}

