/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.DialogUtil;
import ch.sahits.game.graphic.display.dialog.util.TavernDialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
public class TavernCaptainDialog
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    private final Font font;
    private final ObjectProperty<IShip> currentShip;
    @Autowired
    private CaptainsState captainsState;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    private ICaptain captain;
    private final TavernState tavernState;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public TavernCaptainDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.font = font;
        this.city = city;
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.currentShip = new SimpleObjectProperty((Object)this, "currentShip", (Object)city.getActiveShip());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.captain = (ICaptain)this.captainsState.getCaptain(this.city.getCity()).get();
        Text intro = new Text();
        intro.setFont(this.font);
        intro.setWrappingWidth(458.0);
        intro.setLayoutX(30.0);
        intro.setLayoutY(100.0);
        intro.setText(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.dialog1", new Object[]{this.captain.getName()}, this.locale.getCurrentLocal()));
        this.getContent().add((Object)intro);
        GridPane pane1 = new GridPane();
        pane1.setLayoutX(30.0);
        pane1.setLayoutY(200.0);
        pane1.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(100.0), new ColumnConstraints(50.0), new ColumnConstraints(50.0), new ColumnConstraints(50.0)});
        Text age = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.age", new Object[]{this.captain.getAge()}, this.locale.getCurrentLocal()));
        age.setFont(this.font);
        pane1.add((Node)age, 0, 0);
        Text tradingSkill = new Text(String.valueOf(this.captain.getTradingSkillLevel()));
        tradingSkill.setFont(this.font);
        pane1.add((Node)tradingSkill, 1, 0);
        Text navigationSkill = new Text(String.valueOf(this.captain.getNavigationSkillLevel()));
        navigationSkill.setFont(this.font);
        pane1.add((Node)navigationSkill, 2, 0);
        Text fightSkill = new Text(String.valueOf(this.captain.getFightSkillLevel()));
        fightSkill.setFont(this.font);
        pane1.add((Node)fightSkill, 3, 0);
        this.getContent().add((Object)pane1);
        FlowPane salery = new FlowPane(Orientation.HORIZONTAL);
        salery.setLayoutX(30.0);
        salery.setLayoutY(250.0);
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.price", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("salary", this.captain.getSalary());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().add((Object)dt);
        if (this.currentShip.get() == null) {
            Text noShip = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.noShip", new Object[0], this.locale.getCurrentLocal()));
            noShip.setFont(this.font);
            noShip.setLayoutX(30.0);
            noShip.setLayoutY(300.0);
            this.getContent().add((Object)noShip);
        } else {
            GridPane shipCatalogue = this.createShipCatalogue();
            this.getContent().add((Object)shipCatalogue);
            int actionButtonX = 197;
            final OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.hire", new Object[0], this.locale.getCurrentLocal()), this.font);
            action.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    ((IShip)TavernCaptainDialog.this.currentShip.get()).setCaptain(TavernCaptainDialog.this.captain);
                    TavernCaptainDialog.this.captainsState.hireCaptain(TavernCaptainDialog.this.captain, TavernCaptainDialog.this.city.getCity());
                    TavernCaptainDialog.this.executeOnCloseButtonClicked();
                }
            });
            action.setLayoutX(197.0);
            action.setLayoutY(603.0);
            BooleanBinding enableAction = new BooleanBinding(){

                protected boolean computeValue() {
                    IShip iShip = (IShip)TavernCaptainDialog.this.currentShip.get();
                    return iShip != null && !iShip.getCaptian().isPresent();
                }
            };
            action.setDisable(!enableAction.get());
            enableAction.addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                    action.setDisable(newValue == false);
                }
            });
            this.getContent().add((Object)action);
        }
    }

    private GridPane createShipCatalogue() {
        GridPane shipCatalogue = new GridPane();
        shipCatalogue.setLayoutX(30.0);
        shipCatalogue.setLayoutY(300.0);
        shipCatalogue.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(64.0), new ColumnConstraints(330.0), new ColumnConstraints(64.0)});
        BooleanBinding enablePrevNext = this.dialogUtil.enableShipCatalogue(this.city);
        final OpenPatricianSmallWaxButton prevShip = new OpenPatricianSmallWaxButton("<");
        prevShip.setOnAction(this.dialogUtil.createPreviousAction(this.city, this.currentShip));
        prevShip.setDisable(!enablePrevNext.get());
        shipCatalogue.add((Node)prevShip, 0, 0);
        final OpenPatricianSmallWaxButton nextShip = new OpenPatricianSmallWaxButton(">");
        nextShip.setOnAction(this.dialogUtil.createNextAction(this.city, this.currentShip));
        nextShip.setDisable(!enablePrevNext.get());
        shipCatalogue.add((Node)nextShip, 2, 0);
        enablePrevNext.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                nextShip.setDisable(newValue == false);
                prevShip.setDisable(newValue == false);
            }
        });
        Text ship = new Text();
        ship.setFont(this.font);
        ship.textProperty().bind((ObservableValue)new StringBinding(){

            protected String computeValue() {
                return ((IShip)TavernCaptainDialog.this.currentShip.get()).getName();
            }
        });
        shipCatalogue.add((Node)ship, 1, 0);
        GridPane.setHalignment((Node)ship, (HPos)HPos.CENTER);
        return shipCatalogue;
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.tavernDialogUtil.stopTalkingToPerson(this.tavernState, this.city.getPlayer());
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX((ICityPlayerProxyJFX)this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

