/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.graphic.event.task.ConcurrentReconciliation;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class TavernConcurrentDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientTaskFactory taskFactory;

    public TavernConcurrentDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getConcurrent());
        this.setTitle(((IConcurrent)this.currentPerson.get()).getName());
    }

    @PostConstruct
    private void initializeDialog() {
        this.initializeButtons();
        IConcurrent concurrent = (IConcurrent)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernConcurrentDialog.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", this.city.getPlayer().getLastName());
        parameters.put("concurrent", concurrent.getName());
        parameters.put("price", concurrent.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                IConcurrent concurrent = (IConcurrent)TavernConcurrentDialog.this.currentPerson.get();
                int minutes = TavernConcurrentDialog.this.rnd.nextInt(600);
                DateTime postMessage = TavernConcurrentDialog.this.date.getCurrentDate().plusMinutes(minutes);
                String message = TavernConcurrentDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernConcurrentDialog.acceptMessage", new Object[]{concurrent.getConcurrentName()}, TavernConcurrentDialog.this.locale.getCurrentLocal());
                TavernConcurrentDialog.this.taskFactory.getPostponedDisplayMessage(postMessage, message);
                ConcurrentReconciliation reconsialistation = TavernConcurrentDialog.this.taskFactory.getConcurrentReconciliation();
                TavernConcurrentDialog.this.eventHandlerFactory.getSinkConcurrentsShipOrder(concurrent.getConcurrentPlayer(), TavernConcurrentDialog.this.city.getPlayer(), 20, concurrent.getPremium(), reconsialistation);
                TavernConcurrentDialog.this.taskFactory.getOpponentsOrder(concurrent.getConcurrentPlayer(), concurrent.getClientPlayer(), TavernConcurrentDialog.this.city.getPlayer(), concurrent.getPremium() * 2);
                concurrent.leave();
                TavernConcurrentDialog.this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return false;
            }
        };
    }
}

