/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.people.IEscorte;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.ship.IShip;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class TavernEscortDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private EventHandlerFactory eventHandlerFactory;

    public TavernEscortDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getEscorte());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernEscortDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IEscorte escort = (IEscorte)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernEscortDialog.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("destination", escort.getDestination().getName());
        parameters.put("price", escort.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (TavernEscortDialog.this.city.getActiveShip() != null) {
                    IEscorte escort = (IEscorte)TavernEscortDialog.this.currentPerson.get();
                    TavernEscortDialog.this.city.getActiveShip().addPassenger((IPerson)escort);
                    IShip ship = TavernEscortDialog.this.city.getActiveShip();
                    TavernEscortDialog.this.eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, escort.getDestination(), TavernEscortDialog.this.city.getPlayer(), escort.getPremium());
                    TavernEscortDialog.this.clientEventBus.post((Object)new DisplayMessage(TavernEscortDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernEscortDialog.acceptMessage", new Object[]{ship.getName()}, TavernEscortDialog.this.locale.getCurrentLocal())));
                    escort.leave();
                    TavernEscortDialog.this.executeOnCloseButtonClicked();
                }
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return TavernEscortDialog.this.city.getPlayersShips().isEmpty();
            }
        };
    }
}

