/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.TavernDialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.GenericPair;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashMap;
import javafx.scene.Node;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
public class TavernInformantDialogPageTwo
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    private final Font font;
    private final IInformant informant;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    private final TavernState tavernState;

    public TavernInformantDialogPageTwo(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.informant = this.tavernState.getInformant();
    }

    @PostConstruct
    private void initializeDialog() {
        Optional mapSectionPart;
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageOne.title", new Object[]{this.informant.getName()}, this.locale.getCurrentLocal()));
        StringBuffer template = new StringBuffer();
        HashMap parameters = new HashMap();
        if (this.informant.getWareNeeded().isPresent()) {
            GenericPair needed = (GenericPair)this.informant.getWareNeeded().get();
            template.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageTwo.dialog1", new Object[]{((ICity)needed.getFirst()).getName(), this.translator.getLocalDisplayName((EWare)needed.getSecond())}, this.locale.getCurrentLocal()));
        }
        if (this.informant.getWareSurplus().isPresent()) {
            GenericPair surplus = (GenericPair)this.informant.getWareSurplus().get();
            template.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageTwo.dialog2", new Object[]{((ICity)surplus.getFirst()).getName(), this.translator.getLocalDisplayName((EWare)surplus.getSecond())}, this.locale.getCurrentLocal()));
        }
        if ((mapSectionPart = this.informant.getMapSectionPart(this.city.getPlayer())).isPresent()) {
            ArrayList visibleSegs = new ArrayList();
            visibleSegs.addAll(((MapSegmentedImage)mapSectionPart.get()).getSegmentIndices());
            parameters.put("visibleSegments", visibleSegs);
            template.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageTwo.dialog4", new Object[]{((MapSegmentedImage)mapSectionPart.get()).getImageName()}, this.locale.getCurrentLocal()));
        }
        if (this.informant.getPirateLocation().isPresent()) {
            GenericPair pirate = (GenericPair)this.informant.getPirateLocation().get();
            template.append(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageTwo.dialog3", new Object[]{pirate.getFirst(), ((ICity)pirate.getSecond()).getName()}, this.locale.getCurrentLocal()));
        }
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(template.toString(), parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.tavernDialogUtil.stopTalkingToPerson(this.tavernState, this.city.getPlayer());
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX((ICityPlayerProxyJFX)this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

