/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.service.MapSegmentImageFactory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class TavernPirateHunterDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private MapSegmentImageFactory segmentFactory;

    public TavernPirateHunterDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getPirateHunter());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateHunterDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IPirateHunter pirateHunter = (IPirateHunter)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateHunterDialog.dialog1", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", pirateHunter.getClientName());
        parameters.put("amount", pirateHunter.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                TavernPirateHunterDialog.this.removeDecoratedContent();
                TavernPirateHunterDialog.this.removeAcceptButton();
                MapSegmentedImage imageMap = TavernPirateHunterDialog.this.segmentFactory.getRandomPirateNest();
                String loadedText = TavernPirateHunterDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateHunterDialog.acceptMessage", new Object[]{imageMap.getImageName()}, TavernPirateHunterDialog.this.locale.getCurrentLocal());
                HashMap parameters = new HashMap();
                ArrayList visibleSegs = new ArrayList();
                visibleSegs.addAll(imageMap.getSegmentIndices());
                parameters.put("visibleSegments", visibleSegs);
                final DecoratedText dt = TavernPirateHunterDialog.this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TavernPirateHunterDialog.this.getContent().add((Object)dt);
                    }
                });
                IPirateHunter pirateHunter = (IPirateHunter)TavernPirateHunterDialog.this.currentPerson.get();
                IPlayer player = TavernPirateHunterDialog.this.city.getPlayer();
                player.getCompany().updateCash((long)(-pirateHunter.getPremium()));
                player.setSegmentedMap(imageMap);
                pirateHunter.leave();
                TavernPirateHunterDialog.this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return false;
            }
        };
    }
}

