/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.DialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.people.ISailorState;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
public class TavernSailorDialog
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    private final Font font;
    private final ISailorState sailorState;
    private final ObjectProperty<IShip> currentShip;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public TavernSailorDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
        this.sailorState = city.getCity().getCityState().getTavernState().getSailors();
        this.currentShip = new SimpleObjectProperty((Object)this, "currentShip", (Object)city.getActiveShip());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.title", new Object[0], this.locale.getCurrentLocal()));
        VBox topText = new VBox();
        topText.setLayoutX(30.0);
        topText.setLayoutY(100.0);
        final IntegerProperty sailorsInCity = this.sailorState.numberOfSailorsProperty();
        Text firstLine = new Text();
        firstLine.setFont(this.font);
        StringBinding firstLineBinding = new StringBinding(){
            {
                super.bind(new Observable[]{sailorsInCity});
            }

            protected String computeValue() {
                if (sailorsInCity.get() > 1) {
                    return TavernSailorDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.dialog1", new Object[]{sailorsInCity.get()}, TavernSailorDialog.this.locale.getCurrentLocal());
                }
                if (sailorsInCity.get() == 1) {
                    return TavernSailorDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.dialog2", new Object[0], TavernSailorDialog.this.locale.getCurrentLocal());
                }
                return TavernSailorDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.dialog3", new Object[0], TavernSailorDialog.this.locale.getCurrentLocal());
            }
        };
        firstLine.textProperty().bind((ObservableValue)firstLineBinding);
        Text secondLine = new Text();
        secondLine.setFont(this.font);
        secondLine.setText(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.dialog4", new Object[0], this.locale.getCurrentLocal()));
        topText.getChildren().addAll((Object[])new Node[]{firstLine, secondLine});
        this.getContent().add((Object)topText);
        int initialNumberOfSailors = 0;
        if (this.currentShip.get() != null) {
            initialNumberOfSailors = ((IShip)this.currentShip.get()).getNumberOfSailors();
        }
        SimpleIntegerProperty sailorsAdditionalOnShip = new SimpleIntegerProperty(0);
        SimpleIntegerProperty sailorsInTavern = new SimpleIntegerProperty(sailorsInCity.get());
        this.currentShip.addListener((ChangeListener)new ChangeListener<IShip>((IntegerProperty)sailorsAdditionalOnShip, (IntegerProperty)sailorsInTavern, sailorsInCity){
            final /* synthetic */ IntegerProperty val$sailorsAdditionalOnShip;
            final /* synthetic */ IntegerProperty val$sailorsInTavern;
            final /* synthetic */ IntegerProperty val$sailorsInCity;
            {
                this.val$sailorsAdditionalOnShip = integerProperty;
                this.val$sailorsInTavern = integerProperty2;
                this.val$sailorsInCity = integerProperty3;
            }

            public void changed(ObservableValue<? extends IShip> observableValue, IShip oldValue, IShip newValue) {
                this.val$sailorsAdditionalOnShip.set(newValue.getNumberOfSailors());
                this.val$sailorsInTavern.set(this.val$sailorsInCity.get());
            }
        });
        sailorsInCity.addListener((ChangeListener)new ChangeListener<Number>((IntegerProperty)sailorsAdditionalOnShip, (IntegerProperty)sailorsInTavern){
            final /* synthetic */ IntegerProperty val$sailorsAdditionalOnShip;
            final /* synthetic */ IntegerProperty val$sailorsInTavern;
            {
                this.val$sailorsAdditionalOnShip = integerProperty;
                this.val$sailorsInTavern = integerProperty2;
            }

            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                int inTavern = newValue.intValue() - this.val$sailorsAdditionalOnShip.get();
                if (inTavern < 0) {
                    this.val$sailorsAdditionalOnShip.set(Math.max(this.val$sailorsAdditionalOnShip.get() + inTavern, 0));
                    inTavern = 0;
                }
                this.val$sailorsInTavern.set(inTavern);
            }
        });
        GridPane sailorsPane = this.createSailorMoveControls((IntegerProperty)sailorsAdditionalOnShip, (IntegerProperty)sailorsInTavern);
        this.getContent().add((Object)sailorsPane);
        Text selectedShip = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.dialog5", new Object[0], this.locale.getCurrentLocal()));
        selectedShip.setFont(this.font);
        selectedShip.setLayoutX(30.0);
        selectedShip.setLayoutY(250.0);
        this.getContent().add((Object)selectedShip);
        if (this.currentShip.get() == null) {
            Text noShip = new Text("No ship present");
            noShip.setFont(this.font);
            noShip.setLayoutX(30.0);
            noShip.setLayoutY(300.0);
            this.getContent().add((Object)noShip);
        } else {
            GridPane shipSelectionPane = this.dialogUtil.createShipSelection3Lines(this.city, this.currentShip, this.font);
            shipSelectionPane.setLayoutX(30.0);
            shipSelectionPane.setLayoutY(300.0);
            this.getContent().add((Object)shipSelectionPane);
        }
        int actionButtonX = 197;
        final OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.hire", new Object[0], this.locale.getCurrentLocal()), this.font);
        action.setOnAction((EventHandler)new EventHandler<MouseEvent>((IntegerProperty)sailorsAdditionalOnShip){
            final /* synthetic */ IntegerProperty val$sailorsAdditionalOnShip;
            {
                this.val$sailorsAdditionalOnShip = integerProperty;
            }

            public void handle(MouseEvent mouseEvent) {
                ((IShip)TavernSailorDialog.this.currentShip.get()).setNumberOfSailors(this.val$sailorsAdditionalOnShip.get() + ((IShip)TavernSailorDialog.this.currentShip.get()).getNumberOfSailors());
                TavernSailorDialog.this.sailorState.setNumberOfSailors(TavernSailorDialog.this.sailorState.numberOfSailorsProperty().get() - this.val$sailorsAdditionalOnShip.get());
            }
        });
        action.setLayoutX(197.0);
        action.setLayoutY(603.0);
        BooleanBinding enableAction = new BooleanBinding((IntegerProperty)sailorsAdditionalOnShip){
            final /* synthetic */ IntegerProperty val$sailorsAdditionalOnShip;
            {
                this.val$sailorsAdditionalOnShip = integerProperty;
                super.bind(new Observable[]{TavernSailorDialog.this.currentShip, this.val$sailorsAdditionalOnShip});
            }

            protected boolean computeValue() {
                return TavernSailorDialog.this.currentShip.get() != null && this.val$sailorsAdditionalOnShip.get() > 0;
            }
        };
        action.setDisable(!enableAction.get());
        enableAction.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                action.setDisable(newValue == false);
            }
        });
        this.getContent().add((Object)action);
    }

    private GridPane createSailorMoveControls(final IntegerProperty sailorsOnShip, final IntegerProperty sailorsInTavern) {
        GridPane sailorsPane = new GridPane();
        sailorsPane.setLayoutX(100.0);
        sailorsPane.setLayoutY(150.0);
        RowConstraints rowConstraint = new RowConstraints(24.0);
        sailorsPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraint, rowConstraint});
        ColumnConstraints colConstraint = new ColumnConstraints(64.0);
        sailorsPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colConstraint, colConstraint, colConstraint, colConstraint});
        Text tavernTxt = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.tavern", new Object[0], this.locale.getCurrentLocal()));
        tavernTxt.setFont(this.font);
        sailorsPane.add((Node)tavernTxt, 0, 0);
        GridPane.setHalignment((Node)tavernTxt, (HPos)HPos.CENTER);
        Text shipTxt = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ship", new Object[0], this.locale.getCurrentLocal()));
        shipTxt.setFont(this.font);
        sailorsPane.add((Node)shipTxt, 3, 0);
        GridPane.setHalignment((Node)shipTxt, (HPos)HPos.CENTER);
        Text nbInTavern = new Text();
        nbInTavern.setFont(this.font);
        nbInTavern.textProperty().bind((ObservableValue)sailorsInTavern.asString());
        sailorsPane.add((Node)nbInTavern, 0, 1);
        GridPane.setHalignment((Node)nbInTavern, (HPos)HPos.CENTER);
        final OpenPatricianSmallWaxButton toTavernBtn = new OpenPatricianSmallWaxButton("<");
        toTavernBtn.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                sailorsOnShip.set(sailorsOnShip.get() - 1);
                sailorsInTavern.set(sailorsInTavern.get() + 1);
            }
        });
        if (sailorsOnShip.get() < 1 || this.currentShip.get() == null) {
            toTavernBtn.setDisable(true);
        }
        sailorsPane.add((Node)toTavernBtn, 1, 1);
        GridPane.setHalignment((Node)toTavernBtn, (HPos)HPos.CENTER);
        final OpenPatricianSmallWaxButton toShipBtn = new OpenPatricianSmallWaxButton(">");
        toShipBtn.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                sailorsOnShip.set(sailorsOnShip.get() + 1);
                sailorsInTavern.set(sailorsInTavern.get() - 1);
            }
        });
        sailorsOnShip.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                if (newValue.intValue() <= 0) {
                    toTavernBtn.setDisable(true);
                } else {
                    toTavernBtn.setDisable(false);
                }
                if (newValue.intValue() >= ((IShip)TavernSailorDialog.this.currentShip.get()).getMaxNumberOfSailors() || sailorsInTavern.get() <= 0) {
                    toShipBtn.setDisable(true);
                } else {
                    toShipBtn.setDisable(false);
                }
            }
        });
        sailorsInTavern.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                if (newValue.intValue() <= 0) {
                    toShipBtn.setDisable(true);
                } else if (sailorsOnShip.get() < ((IShip)TavernSailorDialog.this.currentShip.get()).getMaxNumberOfSailors() && newValue.intValue() > 0) {
                    toShipBtn.setDisable(false);
                }
            }
        });
        if (sailorsInTavern.get() < 1 || this.currentShip.get() == null) {
            toShipBtn.setDisable(true);
        }
        sailorsPane.add((Node)toShipBtn, 2, 1);
        GridPane.setHalignment((Node)toShipBtn, (HPos)HPos.CENTER);
        Text nbInShip = new Text();
        nbInShip.setFont(this.font);
        nbInShip.textProperty().bind((ObservableValue)sailorsOnShip.asString());
        sailorsPane.add((Node)nbInShip, 3, 1);
        GridPane.setHalignment((Node)nbInShip, (HPos)HPos.CENTER);
        return sailorsPane;
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX((ICityPlayerProxyJFX)this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

