/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.TavernDialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.ITrader;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
public class TavernTraderDialog
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    private final Font font;
    private final ITrader trader;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    private final TavernState tavernState;

    public TavernTraderDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.trader = this.tavernState.getTrader();
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTraderDialog.title", new Object[0], this.locale.getCurrentLocal()));
        IWare ware = this.trader.getWare();
        String loadedText = ware.isBarrelSizedWare() ? this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTraderDialog.dialogBarrel", new Object[]{this.city.getPlayer().getLastName(), this.translator.getLocalDisplayName((EWare)ware)}, this.locale.getCurrentLocal()) : this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTraderDialog.dialogBale", new Object[]{this.city.getPlayer().getLastName(), this.translator.getLocalDisplayName((EWare)ware)}, this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", this.trader.getAmount());
        parameters.put("price", this.trader.getAvgPricePerItem());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        final OpenPatricianLargeWaxButton acceptButton = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[0], this.locale.getCurrentLocal()), this.font);
        int BUTTON_X = 197;
        acceptButton.setLayoutX((double)BUTTON_X);
        int LOWER_BUTTON_Y = 603;
        acceptButton.setLayoutY((double)LOWER_BUTTON_Y);
        acceptButton.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            /*
             * Enabled aggressive block sorting
             */
            public void handle(MouseEvent mouseEvent) {
                IPlayer player = TavernTraderDialog.this.city.getPlayer();
                int price = TavernTraderDialog.this.trader.getAmount() * TavernTraderDialog.this.trader.getAvgPricePerItem();
                ITradingOffice office = TavernTraderDialog.this.city.getPlayer().findTradingOffice(TavernTraderDialog.this.city.getCity());
                if (office != null) {
                    office.move(TavernTraderDialog.this.trader.getWare(), TavernTraderDialog.this.trader.getAmount());
                } else {
                    IShip ship = TavernTraderDialog.this.city.getActiveShip();
                    if (ship == null) {
                        acceptButton.setDisable(true);
                        return;
                    }
                    if (ship.getCapacity() < TavernTraderDialog.this.trader.getAmount()) {
                        acceptButton.setDisable(true);
                        return;
                    }
                    ship.load(TavernTraderDialog.this.trader.getWare(), TavernTraderDialog.this.trader.getAmount(), TavernTraderDialog.this.trader.getAvgPricePerItem());
                }
                player.getCompany().updateCash((long)(-price));
                TavernTraderDialog.this.trader.leave();
                TavernTraderDialog.this.executeOnCloseButtonClicked();
            }
        });
        BooleanBinding disable = this.disableAcceptBinding();
        acceptButton.setDisable(disable.get());
        disable.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                acceptButton.setDisable(newValue.booleanValue());
            }
        });
        this.getContent().addAll((Object[])new Node[]{dt, acceptButton});
    }

    private BooleanBinding disableAcceptBinding() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                ITradingOffice office = TavernTraderDialog.this.city.getPlayer().findTradingOffice(TavernTraderDialog.this.city.getCity());
                IShip ship = TavernTraderDialog.this.city.getActiveShip();
                int barrelAmountFactor = 1;
                if (!TavernTraderDialog.this.trader.getWare().isBarrelSizedWare()) {
                    barrelAmountFactor = 10;
                }
                return office == null && ship == null && ship.getCapacity() < TavernTraderDialog.this.trader.getAmount() * barrelAmountFactor;
            }
        };
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.tavernDialogUtil.stopTalkingToPerson(this.tavernState, this.city.getPlayer());
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX((ICityPlayerProxyJFX)this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

