/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class TavernTransportTraderDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;

    public TavernTransportTraderDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getTransportTrader());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTransportTraderDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        ITransportTrader trader = (ITransportTrader)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTransportTraderDialog.dialog", new Object[]{this.city.getCity().getName(), trader.getDestination().getName()}, this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", trader.getNeededCapacity());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ArrayList ships = Lists.newArrayList((Iterable)TavernTransportTraderDialog.this.city.getPlayersShips());
                Collections.shuffle(ships);
                ITransportTrader trader = (ITransportTrader)TavernTransportTraderDialog.this.currentPerson.get();
                for (IShip ship : ships) {
                    int neededCapacity = trader.getNeededCapacity();
                    if (ship.getCapacity() <= neededCapacity * 10) continue;
                    ship.setOccupiedSpace(neededCapacity);
                    String s = TavernTransportTraderDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTransportTraderDialog.acceptMessage", new Object[]{trader.getDestination().getName(), ship.getName()}, TavernTransportTraderDialog.this.locale.getCurrentLocal());
                    int minutes = TavernTransportTraderDialog.this.rnd.nextInt(600);
                    DateTime postMessage = TavernTransportTraderDialog.this.date.getCurrentDate().plusMinutes(minutes);
                    TavernTransportTraderDialog.this.taskFactory.getPostponedDisplayMessage(postMessage, s);
                    trader.leave();
                    TavernTransportTraderDialog.this.eventHandlerFactory.getUnloadOnArrivalHandler(ship, trader.getDestination(), neededCapacity);
                    break;
                }
                TavernTransportTraderDialog.this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                ITransportTrader trader = (ITransportTrader)TavernTransportTraderDialog.this.currentPerson.get();
                return TavernTransportTraderDialog.this.tavernDialogUtil.noShipWithEnoughCapacityAvailable(TavernTransportTraderDialog.this.city, trader.getNeededCapacity());
            }
        };
    }
}

