/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
public class TavernWarehouseTenantDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private TimedUpdatableTaskList list;

    public TavernWarehouseTenantDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getWarehouseTenant());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernWarehouseTenantDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IWarehouseTenant tenant = (IWarehouseTenant)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernWarehouseTenantDialog.dialog", new Object[]{tenant.getName()}, this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", tenant.getAmount());
        parameters.put("price", tenant.getRentPerWeek());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                final IPlayer player = TavernWarehouseTenantDialog.this.city.getPlayer();
                final IWarehouseTenant tenant = (IWarehouseTenant)TavernWarehouseTenantDialog.this.currentPerson.get();
                final ITradingOffice office = TavernWarehouseTenantDialog.this.city.getPlayer().findTradingOffice(TavernWarehouseTenantDialog.this.city.getCity());
                if (office != null) {
                    office.setOccupiedSpace(office.getOccupiedSpace() + tenant.getAmount());
                    int weeks = TavernWarehouseTenantDialog.this.rnd.nextInt(15) + 5;
                    DateTime currentDate = TavernWarehouseTenantDialog.this.date.getCurrentDate();
                    for (int i = 0; i < weeks; ++i) {
                        currentDate = currentDate.plusWeeks(1);
                        TimedTask task = new TimedTask(){

                            public void run() {
                                player.getCompany().updateCash((long)tenant.getRentPerWeek());
                            }
                        };
                        task.setExecutionTime(currentDate);
                        TavernWarehouseTenantDialog.this.list.add(task);
                    }
                    TimedTask task = new TimedTask(){

                        public void run() {
                            String message = TavernWarehouseTenantDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernWarehouseTenantDialog.acceptMessage1", new Object[0], TavernWarehouseTenantDialog.this.locale.getCurrentLocal());
                            TavernWarehouseTenantDialog.this.clientEventBus.post((Object)new DisplayMessage(message, TavernWarehouseTenantDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernWarehouseTenantDialog.accpetMessage2", new Object[0], TavernWarehouseTenantDialog.this.locale.getCurrentLocal())));
                            office.setOccupiedSpace(office.getOccupiedSpace() - tenant.getAmount());
                        }
                    };
                    task.setExecutionTime(TavernWarehouseTenantDialog.this.date.getCurrentDate().plusWeeks(weeks));
                    TavernWarehouseTenantDialog.this.list.add(task);
                    tenant.leave();
                }
                TavernWarehouseTenantDialog.this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return TavernWarehouseTenantDialog.this.city.getPlayer().findTradingOffice(TavernWarehouseTenantDialog.this.city.getCity()) == null;
            }
        };
    }
}

