/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.DialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.people.IWeaponsDealer;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import ch.sahits.game.openpatrician.util.TransferUtil;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
public class TavernWeaponsDealerDialog
extends CloseButtonDialog {
    private ObjectProperty<ETransferAmount> movableAmount = new SimpleObjectProperty((Object)ETransferAmount.ONE);
    private final ICityPlayerProxyJFX city;
    private final Font font;
    private ObservableList<Object> storage = FXCollections.observableArrayList();
    private IntegerProperty currentStorageIndex = new SimpleIntegerProperty(-1);
    private StringBinding storageDestinationBinding;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private TransferUtil transferUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    private EWeapon[] weapons = new EWeapon[]{EWeapon.SWORD, EWeapon.BOW, EWeapon.CROSSBOW, EWeapon.MUSKET};
    private final IWeaponsDealer weaponsDealer;

    public TavernWeaponsDealerDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
        this.weaponsDealer = city.getCity().getCityState().getTavernState().getWeaponsDealer();
        this.initializeStorage();
        this.initStorageDestionationBinding();
    }

    private void initializeStorage() {
        IShip activeShip = this.city.getActiveShip();
        if (activeShip != null) {
            this.storage.add((Object)activeShip);
        }
        for (IShip ship : this.city.getPlayersShips()) {
            if (ship.equals(activeShip)) continue;
            this.storage.add((Object)ship);
        }
        ITradingOffice office = this.city.getPlayer().findTradingOffice(this.city.getCity());
        if (office != null) {
            this.storage.add((Object)office);
        }
        if (!this.storage.isEmpty()) {
            this.currentStorageIndex.set(0);
        }
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernWeaponsDealerDialog.title", new Object[0], this.locale.getCurrentLocal()));
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernWeaponsDealerDialog.dialog1", new Object[0], this.locale.getCurrentLocal());
        HashMap parameters = new HashMap();
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
        GridPane catalogue = this.createShipCatalogue();
        this.getContent().add((Object)catalogue);
        GridPane weapnsTable = this.createWeaponsTable();
        this.getContent().add((Object)weapnsTable);
        OpenPatricianSmallWaxButton btn1 = new OpenPatricianSmallWaxButton("1", this.font);
        btn1.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                TavernWeaponsDealerDialog.this.movableAmount.setValue((Object)ETransferAmount.ONE);
            }
        });
        OpenPatricianSmallWaxButton btn5 = new OpenPatricianSmallWaxButton("5", this.font);
        btn5.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                TavernWeaponsDealerDialog.this.movableAmount.setValue((Object)ETransferAmount.FIVE);
            }
        });
        OpenPatricianSmallWaxButton btnMax = new OpenPatricianSmallWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernWeaponsDealerDialog.max", new Object[0], this.locale.getCurrentLocal()), this.font);
        btnMax.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                TavernWeaponsDealerDialog.this.movableAmount.setValue((Object)ETransferAmount.MAX);
            }
        });
        this.addButtomControlButtons(btn1, btn5, btnMax);
    }

    private GridPane createWeaponsTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernWeaponsDealerDialog.weaponType", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernWeaponsDealerDialog.dealer", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.buy", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.sell", new Object[0], this.locale.getCurrentLocal())));
        Text storageHeader = new Text();
        storageHeader.setFont(this.font);
        storageHeader.textProperty().bind((ObservableValue)this.storageDestinationBinding);
        header.add((ITableCell)new ControlTableCell((Node)storageHeader));
        header.setAligenment(0, HPos.CENTER);
        header.setAligenment(1, HPos.CENTER);
        header.setAligenment(2, HPos.CENTER);
        header.setAligenment(3, HPos.CENTER);
        header.setAligenment(4, HPos.CENTER);
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.CENTER);
        model.setAligenment(2, HPos.CENTER);
        model.setAligenment(3, HPos.CENTER);
        model.setAligenment(4, HPos.CENTER);
        model.setColumnWidth(new Integer[]{100, 70, 70, 70, 100});
        for (final EWeapon weapon : this.weapons) {
            final IntegerBinding storedAmount = this.getAmountStoredWeapons(weapon);
            final IntegerBinding amountToSell = this.getAmountBinding(storedAmount);
            final IntegerProperty dealerOwnedAmount = this.weaponsDealer.amountAvailableProperty(weapon);
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(weapon)));
            Text dealerAmount = new Text();
            dealerAmount.setFont(this.font);
            dealerAmount.textProperty().bind((ObservableValue)dealerOwnedAmount.asString());
            row.add((ITableCell)new ControlTableCell((Node)dealerAmount));
            OpenPatricianSmallWaxButton buyButton = new OpenPatricianSmallWaxButton("", this.font);
            final IntegerBinding buyPriceBinding = this.weaponsDealer.buyPriceBinding(this.movableAmount, weapon);
            buyButton.textProperty().bind((ObservableValue)buyPriceBinding.asString());
            buyButton.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    if (dealerOwnedAmount.get() > 0) {
                        int amountToBuy = TavernWeaponsDealerDialog.this.transferUtil.calculateAvailableAmount(TavernWeaponsDealerDialog.this.movableAmount, dealerOwnedAmount.get());
                        int avgPrice = buyPriceBinding.get();
                        TavernWeaponsDealerDialog.this.city.getPlayer().getCompany().updateCash((long)(-amountToBuy * avgPrice));
                        if (TavernWeaponsDealerDialog.this.storage.get(TavernWeaponsDealerDialog.this.currentStorageIndex.get()) instanceof ITradingOffice) {
                            ITradingOffice office = (ITradingOffice)TavernWeaponsDealerDialog.this.storage.get(TavernWeaponsDealerDialog.this.currentStorageIndex.get());
                            office.getWeaponStorage().update((IWeapon)weapon, amountToBuy);
                        } else {
                            IShip ship = (IShip)TavernWeaponsDealerDialog.this.storage.get(TavernWeaponsDealerDialog.this.currentStorageIndex.get());
                            ship.move((IWeapon)weapon, amountToBuy);
                        }
                        TavernWeaponsDealerDialog.this.weaponsDealer.move((IWeapon)weapon, -amountToBuy);
                        storedAmount.invalidate();
                    }
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)buyButton));
            OpenPatricianSmallWaxButton sellButton = new OpenPatricianSmallWaxButton("", this.font);
            final IntegerBinding sellPriceBinding = this.weaponsDealer.sellPriceBinding(weapon, amountToSell);
            sellButton.textProperty().bind((ObservableValue)sellPriceBinding.asString());
            sellButton.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    int amount = amountToSell.get();
                    int avgPrice = sellPriceBinding.get();
                    TavernWeaponsDealerDialog.this.city.getPlayer().getCompany().updateCash((long)(amount * avgPrice));
                    if (TavernWeaponsDealerDialog.this.storage.get(TavernWeaponsDealerDialog.this.currentStorageIndex.get()) instanceof ITradingOffice) {
                        ITradingOffice office = (ITradingOffice)TavernWeaponsDealerDialog.this.storage.get(TavernWeaponsDealerDialog.this.currentStorageIndex.get());
                        office.getWeaponStorage().update((IWeapon)weapon, -amount);
                    } else {
                        IShip ship = (IShip)TavernWeaponsDealerDialog.this.storage.get(TavernWeaponsDealerDialog.this.currentStorageIndex.get());
                        ship.move((IWeapon)weapon, -amount);
                    }
                    TavernWeaponsDealerDialog.this.weaponsDealer.move((IWeapon)weapon, amount);
                    storedAmount.invalidate();
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)sellButton));
            Text amountStored = new Text();
            amountStored.setFont(this.font);
            amountStored.textProperty().bind((ObservableValue)storedAmount.asString());
            row.add((ITableCell)new ControlTableCell((Node)amountStored));
            model.add(row);
        }
        GridPane pane = this.dialogUtil.createGridPaneFromModel(model, this.font);
        pane.setLayoutX(30.0);
        pane.setLayoutY(350.0);
        return pane;
    }

    private GridPane createShipCatalogue() {
        GridPane shipCatalogue = new GridPane();
        shipCatalogue.setLayoutX(30.0);
        shipCatalogue.setLayoutY(300.0);
        shipCatalogue.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(64.0), new ColumnConstraints(330.0), new ColumnConstraints(64.0)});
        BooleanBinding enablePrevNext = new BooleanBinding(){

            protected boolean computeValue() {
                return TavernWeaponsDealerDialog.this.storage.size() > 1;
            }
        };
        final OpenPatricianSmallWaxButton prevShip = new OpenPatricianSmallWaxButton("<", this.font);
        prevShip.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (TavernWeaponsDealerDialog.this.storage.size() > 1) {
                    if (TavernWeaponsDealerDialog.this.currentStorageIndex.get() == 0) {
                        TavernWeaponsDealerDialog.this.currentStorageIndex.set(TavernWeaponsDealerDialog.this.storage.size() - 1);
                    } else {
                        TavernWeaponsDealerDialog.this.currentStorageIndex.set(TavernWeaponsDealerDialog.this.currentStorageIndex.get() - 1);
                    }
                }
            }
        });
        prevShip.setDisable(!enablePrevNext.get());
        shipCatalogue.add((Node)prevShip, 0, 0);
        final OpenPatricianSmallWaxButton nextShip = new OpenPatricianSmallWaxButton(">", this.font);
        nextShip.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (TavernWeaponsDealerDialog.this.storage.size() > 1) {
                    if (TavernWeaponsDealerDialog.this.currentStorageIndex.get() == TavernWeaponsDealerDialog.this.storage.size() - 1) {
                        TavernWeaponsDealerDialog.this.currentStorageIndex.set(0);
                    } else {
                        TavernWeaponsDealerDialog.this.currentStorageIndex.set(TavernWeaponsDealerDialog.this.currentStorageIndex.get() + 1);
                    }
                }
            }
        });
        nextShip.setDisable(!enablePrevNext.get());
        shipCatalogue.add((Node)nextShip, 2, 0);
        enablePrevNext.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                nextShip.setDisable(newValue == false);
                prevShip.setDisable(newValue == false);
            }
        });
        Text ship = new Text();
        ship.setFont(this.font);
        ship.textProperty().bind((ObservableValue)this.storageDestinationBinding);
        shipCatalogue.add((Node)ship, 1, 0);
        GridPane.setHalignment((Node)ship, (HPos)HPos.CENTER);
        return shipCatalogue;
    }

    private void initStorageDestionationBinding() {
        if (this.storageDestinationBinding == null) {
            this.storageDestinationBinding = new StringBinding(){

                protected String computeValue() {
                    Object holding = TavernWeaponsDealerDialog.this.storage.get(TavernWeaponsDealerDialog.this.currentStorageIndex.get());
                    if (holding instanceof IShip) {
                        return ((IShip)holding).getName();
                    }
                    if (holding instanceof ITradingOffice) {
                        return TavernWeaponsDealerDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernWeaponsDealerDialog.tradingoffice", new Object[0], TavernWeaponsDealerDialog.this.locale.getCurrentLocal());
                    }
                    throw new RuntimeException("This type should not be here.");
                }
            };
        }
    }

    private IntegerBinding getAmountStoredWeapons(final EWeapon weapon) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{TavernWeaponsDealerDialog.this.storage, TavernWeaponsDealerDialog.this.currentStorageIndex});
            }

            protected int computeValue() {
                if (TavernWeaponsDealerDialog.this.storage.get(TavernWeaponsDealerDialog.this.currentStorageIndex.get()) instanceof ITradingOffice) {
                    ITradingOffice office = (ITradingOffice)TavernWeaponsDealerDialog.this.storage.get(TavernWeaponsDealerDialog.this.currentStorageIndex.get());
                    return office.getWeaponStorage().getWeapon((IWeapon)weapon);
                }
                IShip ship = (IShip)TavernWeaponsDealerDialog.this.storage.get(TavernWeaponsDealerDialog.this.currentStorageIndex.get());
                return ship.getWeaponAmount((IWeapon)weapon);
            }
        };
    }

    private IntegerBinding getAmountBinding(final IntegerBinding maxAmount) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{TavernWeaponsDealerDialog.this.movableAmount, maxAmount});
            }

            protected int computeValue() {
                return TavernWeaponsDealerDialog.this.transferUtil.calculateAvailableAmount(TavernWeaponsDealerDialog.this.movableAmount, maxAmount.get());
            }
        };
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX((ICityPlayerProxyJFX)this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

