/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.TabelViewDialog;
import ch.sahits.game.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IBalanceSheet;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ITownHouse;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWorkShop;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
public class TradeOfficeBalanceDialog
extends TabelViewDialog {
    private Font font;
    protected final ICityPlayerProxyJFX city;
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public TradeOfficeBalanceDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
    }

    private Group createSubTitle() {
        DateBoundStringProperty fromTo = new DateBoundStringProperty(){

            protected String computeValue() {
                return TradeOfficeBalanceDialog.this.date.getStartOfWeek() + " to " + TradeOfficeBalanceDialog.this.date.getEndOfWeek();
            }
        };
        Text fromToText = new Text();
        fromToText.textProperty().bind((ObservableValue)fromTo);
        fromToText.setFont(this.font);
        fromToText.setLayoutX(100.0);
        Text forecast = new Text("Forecast");
        forecast.setFont(this.font);
        forecast.setLayoutX(350.0);
        Group g = new Group();
        g.setManaged(false);
        g.getChildren().addAll((Object[])new Node[]{fromToText, forecast});
        return g;
    }

    @PostConstruct
    private void initializeModelAndDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.title", new Object[0], this.locale.getCurrentLocal()));
        Group subTitle = this.createSubTitle();
        subTitle.setLayoutX(30.0);
        subTitle.setLayoutY(80.0);
        this.getContent().add((Object)subTitle);
        Table model = this.createModel();
        this.setModel(model);
    }

    private Table createModel() {
        ICity cityModel = this.city.getCity();
        final ITradingOffice office = this.city.getPlayer().findTradingOffice(cityModel);
        final List workshops = this.city.getPlayer().findBuildings(cityModel, IWorkShop.class);
        final List townhouse = this.city.getPlayer().findBuildings(cityModel, ITownHouse.class);
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.setAligenment(0, HPos.RIGHT);
        header.setAligenment(1, HPos.LEFT);
        header.setAligenment(2, HPos.LEFT);
        header.setAligenment(3, HPos.LEFT);
        header.setAligenment(4, HPos.LEFT);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{100, 50, 100, 50, 150});
        TableRow row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.rentalIncome", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty rentalIncomeLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getRentalIncome());
            }
        };
        CoinPriceAlwaysVisible coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)rentalIncomeLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty rentalIncomeForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getCurrentWeek().getRentalIncome());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)rentalIncomeForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.wages", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty wagesIncomeLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getWageCosts());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)wagesIncomeLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty wagesIncomeForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getRentalIncome());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)wagesIncomeForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.propertyTax", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty taxLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getPropertyTaxes());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)taxLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty taxForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getPropertyTaxes());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)taxForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.officeTrading", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty tradingLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getOfficeTrading());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)tradingLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty tradingForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getOfficeTrading());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)tradingForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.steward", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty stewardLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getStewardCost());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)stewardLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty stewardForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getStewardCost());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)stewardForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.other", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty otherLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getOtherCosts());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)otherLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty otherForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(office.getBalanceLastWeek().getOtherCosts());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)otherForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.sum", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty sumLastWeek = new DateBoundStringProperty(){

            protected String computeValue() {
                IBalanceSheet bal = office.getBalanceLastWeek();
                int lastWeek = 0;
                lastWeek += bal.getOtherCosts() + bal.getPropertyTaxes() + bal.getStewardCost() + bal.getWageCosts();
                return String.valueOf(lastWeek -= bal.getOfficeTrading() + bal.getRentalIncome());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)sumLastWeek);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        row.add((ITableCell)new StaticTextTableCell(""));
        DateBoundStringProperty sumForecast = new DateBoundStringProperty(){

            protected String computeValue() {
                int forcast = 0;
                IBalanceSheet bal = office.getCurrentWeek();
                forcast += bal.getOtherCosts() + bal.getPropertyTaxes() + bal.getStewardCost() + bal.getWageCosts();
                return String.valueOf(forcast -= bal.getOfficeTrading() + bal.getRentalIncome());
            }
        };
        coinPrice = new CoinPriceAlwaysVisible(this.font);
        coinPrice.amountProperty().bind((ObservableValue)sumForecast);
        row.add((ITableCell)new ControlTableCell((Node)coinPrice));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.buildings", new Object[0], this.locale.getCurrentLocal())));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        row.add((ITableCell)new StaticTextTableCell(""));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.workshops", new Object[0], this.locale.getCurrentLocal())));
        Text nbWorkshops = new Text();
        nbWorkshops.setFont(this.font);
        DateBoundStringProperty nbWsBinding = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(workshops.size());
            }
        };
        nbWorkshops.textProperty().bind((ObservableValue)nbWsBinding);
        row.add((ITableCell)new ControlTableCell((Node)nbWorkshops));
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.workers", new Object[0], this.locale.getCurrentLocal())));
        Text nbWorkers = new Text();
        nbWorkers.setFont(this.font);
        DateBoundStringProperty nbWBinding = new DateBoundStringProperty(){

            protected String computeValue() {
                int people = 0;
                for (IBuilding building : workshops) {
                    people += ((IWorkShop)building).getWorkers();
                }
                return String.valueOf(people);
            }
        };
        nbWorkers.textProperty().bind((ObservableValue)nbWBinding);
        row.add((ITableCell)new ControlTableCell((Node)nbWorkers));
        Text nbWorkersMax = new Text();
        nbWorkersMax.setFont(this.font);
        DateBoundStringProperty nbWBindingMax = new DateBoundStringProperty(){

            protected String computeValue() {
                int maxPeople = 0;
                for (IBuilding building : workshops) {
                    maxPeople += ((IWorkShop)building).getMaxWorkers();
                }
                return "(max. " + String.valueOf(maxPeople) + ")";
            }
        };
        nbWorkersMax.textProperty().bind((ObservableValue)nbWBindingMax);
        row.add((ITableCell)new ControlTableCell((Node)nbWorkersMax));
        model.add(row);
        row = new TableRow();
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.tenements", new Object[0], this.locale.getCurrentLocal())));
        Text nbhouses = new Text();
        nbhouses.setFont(this.font);
        DateBoundStringProperty nbHouseBinding = new DateBoundStringProperty(){

            protected String computeValue() {
                return String.valueOf(townhouse.size());
            }
        };
        nbhouses.textProperty().bind((ObservableValue)nbHouseBinding);
        row.add((ITableCell)new ControlTableCell((Node)nbhouses));
        row.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.tenants", new Object[0], this.locale.getCurrentLocal())));
        Text nbTenants = new Text();
        nbTenants.setFont(this.font);
        DateBoundStringProperty nbTBinding = new DateBoundStringProperty(){

            protected String computeValue() {
                int people = 0;
                for (IBuilding building : townhouse) {
                    people += ((ITownHouse)building).getOccupancy();
                }
                return String.valueOf(people);
            }
        };
        nbTenants.textProperty().bind((ObservableValue)nbTBinding);
        row.add((ITableCell)new ControlTableCell((Node)nbTenants));
        Text nbTenantsMax = new Text();
        nbTenantsMax.setFont(this.font);
        DateBoundStringProperty nbTBindingMax = new DateBoundStringProperty(){

            protected String computeValue() {
                int maxPeople = 0;
                for (IBuilding building : townhouse) {
                    maxPeople += ((ITownHouse)building).getCapacity();
                }
                return TradeOfficeBalanceDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.maxPeople", new Object[]{String.valueOf(maxPeople)}, TradeOfficeBalanceDialog.this.locale.getCurrentLocal());
            }
        };
        nbTenantsMax.textProperty().bind((ObservableValue)nbTBindingMax);
        row.add((ITableCell)new ControlTableCell((Node)nbTenantsMax));
        model.add(row);
        return model;
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }

    private abstract class DateBoundStringProperty
    extends StringBinding {
        private DateBoundStringProperty() {
            super.bind(new Observable[]{TradeOfficeBalanceDialog.this.date.getCurrentDateProperty()});
        }
    }
}

