/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.IWare;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

class Ship2CityJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX dialog;

    public Ship2CityJFXAction(IWare ware, ITransferableJFX dialog) {
        this.ware = ware;
        this.dialog = dialog;
    }

    @Override
    public void run() {
        ICityPlayerProxyJFX city = this.dialog.getCityPlayerProxy();
        int amountOnShip = city.getActiveShip().getWare(this.ware).getAmount();
        if (amountOnShip > 0) {
            int availableAmountCity = city.getCity().getWare(this.ware).getAmount();
            int amount2Move = this.dialog.getAmount(amountOnShip);
            int avgPrice = this.dialog.getMovableAmount() == ETransferAmount.MAX ? this.ware.getMaxValueSell() : this.ware.sellPrice((IntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amount2Move));
            city.getCity().move(this.ware, amount2Move, city.getPlayer());
            int sold = city.getActiveShip().unload(this.ware, -amount2Move);
            city.getPlayer().updateCash(avgPrice * sold);
        }
    }
}

