/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.IWare;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

class Storage2CityJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX dialog;

    public Storage2CityJFXAction(IWare ware, ITransferableJFX dialog) {
        this.ware = ware;
        this.dialog = dialog;
    }

    @Override
    public void run() {
        int amountInStorage;
        ICityPlayerProxyJFX city = this.dialog.getCityPlayerProxy();
        ITradingOffice office = city.getPlayer().findTradingOffice(city.getCity());
        if (office != null && (amountInStorage = office.getWare(this.ware).getAmount()) > 0) {
            int availableAmountCity = city.getCity().getWare(this.ware).getAmount();
            int amount2Move = this.dialog.getAmount(amountInStorage);
            int avgPrice = this.dialog.getMovableAmount() == ETransferAmount.MAX ? this.ware.getMaxValueSell() : this.ware.sellPrice((IntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amount2Move));
            city.getCity().move(this.ware, amount2Move, city.getPlayer());
            int sold = office.move(this.ware, -amount2Move);
            city.getPlayer().updateCash(avgPrice * sold);
        }
    }
}

