/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.gameplay.internal;

import ch.sahits.game.graphic.display.gameplay.internal.CityHallScenePolygonInitializer;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.gameplay.internal.LoanerScenePolygonInitializer;
import ch.sahits.game.graphic.display.gameplay.internal.MarketScenePolygonInitializer;
import ch.sahits.game.graphic.display.gameplay.internal.PortScenePolygonInitializer;
import ch.sahits.game.graphic.display.gameplay.internal.ScenePolygonInitialzer;
import ch.sahits.game.graphic.display.gameplay.internal.ShipyardScenePolygonInitializer;
import ch.sahits.game.graphic.display.gameplay.internal.TavernScenePolygonInitializer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PolygonInitializerFactory {
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    @Autowired
    private PortScenePolygonInitializer portSceneInitializer;
    @Autowired
    private MarketScenePolygonInitializer marketSceneInitializer;
    @Autowired
    private ShipyardScenePolygonInitializer shipyardSceneInitializer;
    @Autowired
    private TavernScenePolygonInitializer tavernSceneInitializer;
    @Autowired
    private CityHallScenePolygonInitializer cityHallSceneInitializer;
    @Autowired
    private LoanerScenePolygonInitializer loanerSceneInitializer;

    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    public ScenePolygonInitialzer getScenePolygonInitializer() {
        switch ((EScene)((Object)this.currentScene.get())) {
            case PORT: {
                return this.portSceneInitializer;
            }
            case MARKET: {
                return this.marketSceneInitializer;
            }
            case SHIPYARD: {
                return this.shipyardSceneInitializer;
            }
            case TAVERN: {
                return this.tavernSceneInitializer;
            }
            case CITY_HALL: {
                return this.cityHallSceneInitializer;
            }
            case LOANER: {
                return this.loanerSceneInitializer;
            }
        }
        throw new IllegalStateException("Unsupported scene: " + this.currentScene.get());
    }
}

