/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.gameplay.internal;

import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.IPolygonScaling;
import ch.sahits.game.graphic.image.ImageScaleState;
import ch.sahits.game.graphic.image.model.ImageData;
import ch.sahits.game.graphic.image.model.NamedPolygon;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Polygon;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class ScenePolygonInitialzer {
    protected static final Logger logger = Logger.getLogger(ScenePolygonInitialzer.class);
    private final String SCENE_IMAGE_NAME;
    @Autowired
    protected IDataImageLoader xmlLoader;
    @Autowired
    @Qualifier(value="polygonScaling")
    private IPolygonScaling scaler;

    public List<Polygon> initialzePolygons(ImageScaleState state) {
        ImageData imageData = this.xmlLoader.getImageData(this.SCENE_IMAGE_NAME);
        Preconditions.checkNotNull((Object)imageData, (Object)("There is not imageData for " + this.SCENE_IMAGE_NAME));
        ImageData recalculated = this.scaler.recalculatePolygons(imageData, state);
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(recalculated.getPolygons().size());
        ArrayList sortedPolygons = new ArrayList(recalculated.getPolygons().entrySet());
        Collections.sort(sortedPolygons, new PolygonComparator());
        for (Map.Entry entry : sortedPolygons) {
            NamedPolygon poly = (NamedPolygon)entry.getValue();
            logger.info((Object)("Add polygon: " + poly));
            this.addAction(poly);
            polygons.add((Polygon)poly);
        }
        return polygons;
    }

    private void addAction(NamedPolygon poly) {
        String name = poly.getName();
        EventHandler<MouseEvent> eventHandler = this.createEventHandler(name);
        poly.setOnMousePressed(eventHandler);
    }

    protected abstract EventHandler<MouseEvent> createEventHandler(String var1);

    public ScenePolygonInitialzer(String sceneName) {
        this.SCENE_IMAGE_NAME = sceneName;
    }

    protected static class PolygonComparator
    implements Comparator<Map.Entry<Integer, NamedPolygon>> {
        protected PolygonComparator() {
        }

        @Override
        public int compare(Map.Entry<Integer, NamedPolygon> o1, Map.Entry<Integer, NamedPolygon> o2) {
            return o2.getKey().compareTo(o1.getKey());
        }
    }
}

