/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.scene;

import ch.sahits.game.graphic.display.SceneChangeable;
import ch.sahits.game.graphic.display.scene.MainGameScene;
import ch.sahits.game.graphic.display.util.GameOptionsService;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.javafx.OpenPatricianScene;
import ch.sahits.game.javafx.control.OpenPatricianSlider;
import ch.sahits.game.javafx.control.OpenPatricianSpinner;
import ch.sahits.game.javafx.control.OpenPatricianStoneButton;
import ch.sahits.game.javafx.control.OpenPatricianWoodenTextInput;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.GameFactory;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import ch.sahits.game.util.UIFactory;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
public class InGameOptionsScene
extends OpenPatricianScene {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private UIFactory uiFactory;
    @Autowired
    private GameFactory gameFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private GameOptionsService gameOptions;
    @Autowired
    private Date date;
    @Autowired
    private IFontLoader fontLoader;
    private IGame game;
    private Font font24;
    private SceneChangeable sceneChangeable;

    public InGameOptionsScene(double width, double heigth) {
        super((Parent)new StackPane(), width, heigth);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(this.getStyleSheetFilename()).toExternalForm());
    }

    public SceneChangeable getSceneChangeable() {
        return this.sceneChangeable;
    }

    public void setSceneChangeable(SceneChangeable sceneChangeable) {
        this.sceneChangeable = sceneChangeable;
    }

    private String getStyleSheetFilename() {
        return "newGame.css";
    }

    @PostConstruct
    private void createControls() {
        this.game = this.gameFactory.getGame();
        this.font24 = this.fontLoader.createDefaultFont(24);
        StackPane root = (StackPane)this.getRoot();
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"grid");
        grid.setAlignment(Pos.CENTER);
        grid.getColumnConstraints().add((Object)new ColumnConstraints(200.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(300.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(250.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(100.0));
        Label loadLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.load", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)loadLbl, 0, 0);
        OpenPatricianSpinner lodableGames = new OpenPatricianSpinner(this.font24);
        grid.add((Node)lodableGames, 1, 0);
        GridPane.setHalignment((Node)lodableGames, (HPos)HPos.LEFT);
        lodableGames.setOptionsMap(this.gameOptions.getSavegames());
        lodableGames.setMaxWidth(250.0);
        OpenPatricianStoneButton loadBtn = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.load", new Object[0], this.locale.getCurrentLocal()), this.font24);
        grid.add((Node)loadBtn, 3, 0);
        GridPane.setHalignment((Node)loadBtn, (HPos)HPos.LEFT);
        Label saveLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.save", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)saveLbl, 0, 1);
        OpenPatricianSpinner saveableGames = new OpenPatricianSpinner(this.font24);
        grid.add((Node)saveableGames, 1, 1);
        GridPane.setHalignment((Node)saveableGames, (HPos)HPos.LEFT);
        saveableGames.setOptionsMap(this.gameOptions.getSavegames());
        saveableGames.setMaxWidth(250.0);
        OpenPatricianWoodenTextInput newSaveGame = new OpenPatricianWoodenTextInput(this.font24);
        newSaveGame.setSize(25);
        grid.add((Node)newSaveGame, 2, 1);
        OpenPatricianStoneButton saveBtn = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.save", new Object[0], this.locale.getCurrentLocal()), this.font24);
        grid.add((Node)saveBtn, 3, 1);
        GridPane.setHalignment((Node)saveBtn, (HPos)HPos.LEFT);
        Label gameSpeedLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.gameSpeed", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)gameSpeedLbl, 0, 2);
        final OpenPatricianSlider speed = new OpenPatricianSlider(this.font24, 200);
        speed.setValues(this.gameOptions.getGameSpeedList());
        int index = 0;
        final EGameSpeed currentSpeed = this.game.getGameSpeed();
        for (int i = 0; i < EGameSpeed.values().length; ++i) {
            if (!currentSpeed.equals((Object)EGameSpeed.values()[i])) continue;
            index = i;
            break;
        }
        speed.selectedIndexProperty().setValue((Number)index);
        grid.add((Node)speed, 1, 2);
        GridPane.setHalignment((Node)speed, (HPos)HPos.LEFT);
        OpenPatricianStoneButton quit = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.quit", new Object[0], this.locale.getCurrentLocal()), this.font24);
        quit.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                mouseEvent.consume();
                Platform.exit();
                System.exit(0);
            }
        });
        grid.add((Node)quit, 0, 6);
        GridPane.setHalignment((Node)quit, (HPos)HPos.LEFT);
        OpenPatricianStoneButton back = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.back", new Object[0], this.locale.getCurrentLocal()), this.font24);
        grid.add((Node)back, 3, 6);
        GridPane.setHalignment((Node)back, (HPos)HPos.RIGHT);
        back.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                EGameSpeed gameSpeed = EGameSpeed.values()[speed.getSelectedIndex()];
                if (gameSpeed != currentSpeed) {
                    InGameOptionsScene.this.game.setGameSpeed(gameSpeed);
                }
                MainGameScene mainGame = InGameOptionsScene.this.uiFactory.getMainGameScene(InGameOptionsScene.this.getWidth(), InGameOptionsScene.this.getHeight());
                InGameOptionsScene.this.getSceneChangeable().changeScene(mainGame);
            }
        });
        root.getChildren().add((Object)grid);
    }
}

