/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.util;

import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@LazySingleton
public class GameOptionsService {
    private static final String SAVEGAME_DIR = ".OpenPatrician" + File.separatorChar + "savegames";
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    private File savegameDir;

    @PostConstruct
    private void init() {
        File userHome = new File(System.getProperty("user.home"));
        this.savegameDir = new File(userHome, SAVEGAME_DIR);
        if (!this.savegameDir.exists()) {
            this.savegameDir.mkdir();
        }
    }

    public List<String> getGameSpeedList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.break", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.slow", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.normal", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.fast", new Object[0], this.locale.getCurrentLocal()));
        return l;
    }

    public Map<String, String> getSavegames() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".savegame");
            }
        };
        String[] savegames = this.savegameDir.list(filter);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String savegame : savegames) {
            map.put(savegame, savegame);
        }
        return map;
    }
}

