/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.event.task;

import ch.sahits.game.graphic.event.task.IDelayedCaughtAction;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
class DelayedCaughtAction
extends TimedTask
implements IDelayedCaughtAction {
    private final IPlayer player;
    @Autowired
    private Date date;
    @Autowired
    private Random rnd;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public DelayedCaughtAction(IPlayer player) {
        this.player = player;
    }

    @PostConstruct
    private void initialize() {
        this.setExecutionTime(this.date.getCurrentDate().plusDays(5));
    }

    @Override
    public void run() {
        int penalty = (int)Math.abs((double)(this.player.getCash() / 200L) * this.rnd.nextDouble());
        String s = this.messageSource.getMessage("ch.sahits.game.graphic.event.task.DelayedCaughtAction.message1", new Object[]{penalty}, this.locale.getCurrentLocal());
        DisplayMessage msg = new DisplayMessage(s, this.messageSource.getMessage("ch.sahits.game.graphic.event.task.DelayedCaughtAction.message2", new Object[0], this.locale.getCurrentLocal()));
        this.clientEventBus.post((Object)msg);
        this.player.updateCash(-penalty);
    }
}

