/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.event.task;

import ch.sahits.game.event.ShipAttackEvent;
import ch.sahits.game.event.handler.TimedEventListener;
import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
public class OpponentsOrder
extends TimedTask {
    private final IPlayer opponent;
    private final IPlayer client;
    private final IPlayer player;
    private final int premium;
    @Autowired
    private TimedUpdatableTaskList list;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private Date date;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    private TimedEventListener order;

    public OpponentsOrder(IPlayer opponent, IPlayer client, IPlayer player, int premium) {
        this.opponent = opponent;
        this.client = client;
        this.player = player;
        this.premium = premium;
    }

    @PostConstruct
    private void initializeEventBus() {
        this.setExecutionTime(this.date.getCurrentDate().plusDays(10));
        this.clientServerEventBus.register((Object)this);
        this.list.add((TimedTask)this);
    }

    public void run() {
        this.clientEventBus.post((Object)new DisplayMessage(this.messageSource.getMessage("ch.sahits.game.graphic.event.task.OpponentsOrder.message1", new Object[]{this.client.getName(), this.client.getLastName(), this.premium}, this.locale.getCurrentLocal())));
        this.order = this.eventHandlerFactory.getSinkConcurrentsShipOrder(this.client, this.opponent, 10, this.premium, null);
        this.clientServerEventBus.unregister((Object)this.order);
    }

    @Subscribe
    public void handleShipAttack(ShipAttackEvent event) {
        IPlayer attackedOwner = event.getAttackedShip().getOwner();
        IPlayer attackingOwner = event.getAttackingShip().getOwner();
        if (attackedOwner != null && attackedOwner.equals(this.opponent) && attackingOwner != null && attackingOwner.equals(this.player)) {
            this.clientServerEventBus.unregister((Object)this);
            if (this.order != null) {
                this.clientServerEventBus.unregister((Object)this.order);
            }
        }
    }
}

