/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.graphic.javafx.display.ISceneEventHandler;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class LoanerSceneEventHandler
implements ISceneEventHandler {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    private IDialogContoller dialogContoller;

    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        ViewChangeCityPlayerProxyJFX cityProxy;
        Preconditions.checkNotNull((Object)this.dialogContoller, (Object)"Dialog controller must be initialized first");
        if (eventNotice == EViewChangeEvent.CLOSE_DIALOG) {
            this.dialogContoller.closeDialog();
        }
        if (eventNotice instanceof ViewChangeCityPlayerProxyJFX && (cityProxy = (ViewChangeCityPlayerProxyJFX)eventNotice).getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_PORT) {
            this.clientEventBus.post((Object)new NoticeBoardClose());
            this.currentScene.set((Object)EScene.PORT);
            this.dialogContoller.changeScene();
        }
        if (eventNotice instanceof ENoticeItem) {
            EDialogType dialogType;
            switch ((ENoticeItem)((Object)eventNotice)) {
                case LOANER_TAKE: {
                    dialogType = EDialogType.LOANER_TAKE;
                    break;
                }
                case LOANER_GIVE: {
                    dialogType = EDialogType.LOANER_GIVE;
                    break;
                }
                case LOANER_REPAY: {
                    dialogType = EDialogType.LOANER_REPAY;
                    break;
                }
                case LOANER_LIST: {
                    dialogType = EDialogType.LOANER_LIST;
                    break;
                }
                default: {
                    throw new RuntimeException("Not yet implemented eventNotice: " + eventNotice);
                }
            }
            this.dialogContoller.replaceDialog(dialogType);
        }
    }
}

