/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.javafx.display.CityHallSceneEventHandler;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.graphic.javafx.display.ISceneEventHandler;
import ch.sahits.game.graphic.javafx.display.LoanerSceneEventHandler;
import ch.sahits.game.graphic.javafx.display.MarketSceneEventHandler;
import ch.sahits.game.graphic.javafx.display.PortSceneEventHandler;
import ch.sahits.game.graphic.javafx.display.ShipyardSceneEventHandler;
import ch.sahits.game.graphic.javafx.display.TavernSceneEventHandler;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SceneEventHandlerFactory {
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    @Autowired
    private PortSceneEventHandler portSceneHandler;
    @Autowired
    private MarketSceneEventHandler marketSceneHandler;
    @Autowired
    private ShipyardSceneEventHandler shipyardSceneHandler;
    @Autowired
    private TavernSceneEventHandler tavernSceneHandler;
    @Autowired
    private CityHallSceneEventHandler cityHallSceneEventHandler;
    @Autowired
    private LoanerSceneEventHandler loanerSceneEventHandler;

    @PostConstruct
    private void initializeBinding() {
        this.portSceneHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.marketSceneHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.shipyardSceneHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.tavernSceneHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.cityHallSceneEventHandler.currentSceneProperty().bindBidirectional(this.currentScene);
        this.loanerSceneEventHandler.currentSceneProperty().bindBidirectional(this.currentScene);
    }

    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    public void setUpDialogController(IDialogContoller controller) {
        this.portSceneHandler.setDialogContoller(controller);
        this.marketSceneHandler.setDialogContoller(controller);
        this.shipyardSceneHandler.setDialogContoller(controller);
        this.tavernSceneHandler.setDialogContoller(controller);
        this.cityHallSceneEventHandler.setDialogContoller(controller);
        this.loanerSceneEventHandler.setDialogContoller(controller);
    }

    public ISceneEventHandler getSceneEventHandler() {
        switch ((EScene)((Object)this.currentScene.get())) {
            case PORT: {
                return this.portSceneHandler;
            }
            case MARKET: {
                return this.marketSceneHandler;
            }
            case SHIPYARD: {
                return this.shipyardSceneHandler;
            }
            case TAVERN: {
                return this.tavernSceneHandler;
            }
            case CITY_HALL: {
                return this.cityHallSceneEventHandler;
            }
            case LOANER: {
                return this.loanerSceneEventHandler;
            }
        }
        throw new IllegalStateException("Unsupported scene: " + this.currentScene.get());
    }
}

