/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.graphic.javafx.display.ISceneEventHandler;
import com.google.common.base.Preconditions;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.stereotype.Component;

@Component
public class ShipyardSceneEventHandler
implements ISceneEventHandler {
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    private IDialogContoller dialogContoller;

    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        Preconditions.checkNotNull((Object)this.dialogContoller, (Object)"Dialog controller must be initialized first");
        if (eventNotice == EViewChangeEvent.CLOSE_DIALOG) {
            this.dialogContoller.closeDialog();
        }
        if (eventNotice instanceof ViewChangeCityPlayerProxyJFX) {
            ViewChangeCityPlayerProxyJFX cityProxy = (ViewChangeCityPlayerProxyJFX)eventNotice;
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.NOTICE_SHIPYARD) {
                this.dialogContoller.setNewDialog(EDialogType.SHIPYARD_CONSTRUCTION);
            }
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_PORT) {
                this.currentScene.set((Object)EScene.PORT);
                this.dialogContoller.changeScene();
            }
        }
        if (eventNotice instanceof ENoticeItem) {
            EDialogType dialogType;
            switch ((ENoticeItem)((Object)eventNotice)) {
                case SHIPYARD_CONSTRUCTION: {
                    dialogType = EDialogType.SHIPYARD_CONSTRUCTION;
                    break;
                }
                case SHIPYARD_CONSTRUCTION_LIST: {
                    dialogType = EDialogType.SHIPYARD_CONSTRUCTION_LIST;
                    break;
                }
                case SHIPYARD_RENAME: {
                    dialogType = EDialogType.SHIPYARD_RENAME;
                    break;
                }
                case SHIPYARD_REPAIR: {
                    dialogType = EDialogType.SHIPYARD_REPAIR;
                    break;
                }
                case SHIPYARD_REPAIR_LIST: {
                    dialogType = EDialogType.SHIPYARD_REPAIR_LIST;
                    break;
                }
                case SHIPYARD_UPGRADE: {
                    dialogType = EDialogType.SHIPYARD_UPGRADE;
                    break;
                }
                default: {
                    throw new RuntimeException("Not yet implemented eventNotice: " + eventNotice);
                }
            }
            this.dialogContoller.replaceDialog(dialogType);
        }
    }
}

