/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.graphic.javafx.display.ISceneEventHandler;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class TavernSceneEventHandler
implements ISceneEventHandler {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    private IDialogContoller dialogContoller;

    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        ViewChangeCityPlayerProxyJFX cityProxy;
        Preconditions.checkNotNull((Object)this.dialogContoller, (Object)"Dialog controller must be initialized first");
        if (eventNotice == EViewChangeEvent.CLOSE_DIALOG) {
            this.dialogContoller.closeDialog();
        }
        if (eventNotice instanceof ViewChangeCityPlayerProxyJFX && (cityProxy = (ViewChangeCityPlayerProxyJFX)eventNotice).getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_PORT) {
            this.clientEventBus.post((Object)new NoticeBoardClose());
            this.currentScene.set((Object)EScene.PORT);
            this.dialogContoller.changeScene();
        }
        if (eventNotice instanceof ENoticeItem) {
            EDialogType dialogType;
            switch ((ENoticeItem)((Object)eventNotice)) {
                case TAVERN_SAILORS: {
                    dialogType = EDialogType.TAVERN_SAILORS;
                    break;
                }
                case TAVERN_CAPTAIN: {
                    dialogType = EDialogType.TAVERN_CAPTAIN;
                    break;
                }
                case TAVERN_WEAPONS_DEALER: {
                    dialogType = EDialogType.TAVERN_WEAPONS_DEALER;
                    break;
                }
                case TAVERN_PIRATE: {
                    dialogType = EDialogType.TAVERN_PIRATE;
                    break;
                }
                case TAVERN_TRADER: {
                    dialogType = EDialogType.TAVERN_TRADER;
                    break;
                }
                case TAVERN_SIDE_ROOM: {
                    dialogType = EDialogType.TAVERN_SIDE_ROOM;
                    break;
                }
                case TAVERN_COURIER: {
                    dialogType = EDialogType.TAVERN_COURIER;
                    break;
                }
                case TAVERN_BURGLAR: {
                    dialogType = EDialogType.TAVERN_BURGLAR;
                    break;
                }
                case TAVERN_TRANSPORT_TRADER: {
                    dialogType = EDialogType.TAVERN_TRANSPORT_TRADER;
                    break;
                }
                case TAVERN_TRAVELER: {
                    dialogType = EDialogType.TAVERN_TRAVELER;
                    break;
                }
                case TAVERN_TREASUREMAP_OWNER: {
                    dialogType = EDialogType.TAVERN_TREASUREMAP_OWNER;
                    break;
                }
                case TAVERN_WAREHOUSE_TENANT: {
                    dialogType = EDialogType.TAVERN_WAREHOUSE_TENANT;
                    break;
                }
                case TAVERN_SMUGGLER: {
                    dialogType = EDialogType.TAVERN_SMUGGLER;
                    break;
                }
                case TAVERN_PIRATE_HUNTER: {
                    dialogType = EDialogType.TAVERN_PIRATE_HUNTER;
                    break;
                }
                case TAVERN_PATROL: {
                    dialogType = EDialogType.TAVERN_PATROL;
                    break;
                }
                case TAVERN_BUYER: {
                    dialogType = EDialogType.TAVERN_BUYER;
                    break;
                }
                case TAVERN_CONCURRENT: {
                    dialogType = EDialogType.TAVERN_CONCURRENT;
                    break;
                }
                case TAVERN_ESCORTE: {
                    dialogType = EDialogType.TAVERN_ESCORTE;
                    break;
                }
                case TAVERN_FUGATIVE: {
                    dialogType = EDialogType.TAVERN_FUGATIVE;
                    break;
                }
                case TAVERN_INFORMANT_1: {
                    dialogType = EDialogType.TAVERN_INFORMANT_1;
                    break;
                }
                case TAVERN_INFORMANT_2: {
                    dialogType = EDialogType.TAVERN_INFORMANT_2;
                    break;
                }
                default: {
                    throw new RuntimeException("Not yet implemented eventNotice: " + eventNotice);
                }
            }
            this.dialogContoller.replaceDialog(dialogType);
        }
    }
}

