/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.graphic.display.OpenPaticianApplicationWindow;
import ch.sahits.game.graphic.display.SceneChangeable;
import ch.sahits.game.graphic.display.scene.InGameOptionsScene;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.javafx.control.TransparentImageViewClickableArea;
import ch.sahits.game.util.UIFactory;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class MainMenu
extends Group {
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private IDataImageLoader imageLoader;
    @Autowired
    private UIFactory uiFactory;
    private SceneChangeable sceneChangeable;

    public MainMenu() {
        this.setManaged(false);
    }

    @PostConstruct
    private void initializeControls() {
        this.sceneChangeable = OpenPaticianApplicationWindow.getApplication();
        HBox iconBar = new HBox(3.0);
        ImageView options = new ImageView(this.imageLoader.getImage("icons/64/anchor"));
        options.setScaleX(0.5);
        options.setScaleY(0.5);
        options.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                Scene currentScene = MainMenu.this.getScene();
                InGameOptionsScene options = MainMenu.this.uiFactory.getInGameOptionsScene(currentScene.getWidth(), currentScene.getHeight());
                options.setSceneChangeable(MainMenu.this.sceneChangeable);
                MainMenu.this.sceneChangeable.changeScene(options);
            }
        });
        TransparentImageViewClickableArea optionClick = new TransparentImageViewClickableArea(options);
        iconBar.getChildren().addAll((Object[])new Node[]{options, optionClick});
        iconBar.setLayoutX(-12.0);
        iconBar.setLayoutY(-12.0);
        this.getChildren().addAll((Object[])new Node[]{iconBar});
    }
}

