/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.event.data.NewGameClient;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.image.IImageUtilities;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.IMap;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
public class MiniMap
extends Group {
    @Autowired
    private IMap map;
    @Autowired
    private IImageUtilities imageUtilities;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    private ImageView imgView;

    @PostConstruct
    private void initializeControl() {
        this.clientServerEventBus.register((Object)this);
        this.setManaged(false);
        this.imgView = new ImageView();
        this.imgView.setFitWidth(236.0);
        this.imgView.setFitHeight(192.0);
        this.imgView.setPreserveRatio(false);
        this.getChildren().addAll((Object[])new Node[]{this.imgView});
    }

    @Subscribe
    public void initializeState(NewGameClient newGameDTO) {
        Image mapImage = this.imageUtilities.createMapWithCities(this.map, newGameDTO.getPlayer());
        mapImage = this.imageUtilities.createImageWithShipsInCities(this.map, newGameDTO.getPlayer(), mapImage);
        Dimension2D dim = this.map.getDimension();
        double factor = 192.0 / dim.getHeight();
        double widthOrigImg = 236.0 / factor;
        double xlocation = newGameDTO.getPlayer().getHometown().getCoordinates().getX();
        double x = Math.max(0.0, xlocation - widthOrigImg / 2.0);
        Rectangle2D viewport = new Rectangle2D(x, 0.0, widthOrigImg, dim.getHeight());
        this.imgView.setViewport(viewport);
        this.imgView.setImage(mapImage);
    }
}

