/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.util;

import ch.sahits.game.graphic.display.OpenPaticianApplicationWindow;
import ch.sahits.game.graphic.display.scene.CreditsScene;
import ch.sahits.game.graphic.display.scene.HanseaticHistoryScene;
import ch.sahits.game.graphic.display.scene.InGameOptionsScene;
import ch.sahits.game.graphic.display.scene.MainGameScene;
import ch.sahits.game.graphic.display.scene.NewGameScene;
import ch.sahits.game.graphic.display.scene.StartupScene;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.IJavaFXControlLoader;
import ch.sahits.game.graphic.image.impl.FontLoader;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.control.GameStatus;
import ch.sahits.game.javafx.control.MainMenu;
import ch.sahits.game.javafx.control.MiniMap;
import ch.sahits.game.javafx.control.NoticeBoard;
import ch.sahits.game.javafx.control.SubMenu;
import ch.sahits.game.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.collections.NonReplacableMap;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import javafx.scene.Scene;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class UIFactory {
    @Autowired
    private ApplicationContext context;
    private final NonReplacableMap<String, Scene> sceneMap = new NonReplacableMap();
    private IJavaFXControlLoader jfxControlLoader;

    @PostConstruct
    private void init() {
        this.jfxControlLoader = new JavaFXControlLoader();
    }

    public IDataImageLoader getXMLImageLoader() {
        return (IDataImageLoader)this.context.getBean("mainScreenXMLImageLoader");
    }

    public MainGameScene getMainGameScene(double width, double heigth) {
        if (!this.sceneMap.containsKey((Object)"mainGameScene")) {
            this.sceneMap.put((Object)"mainGameScene", (Object)((Scene)this.context.getBean("mainGameScene", new Object[]{width, heigth, this.getXMLImageLoader(), this.jfxControlLoader})));
        }
        return (MainGameScene)((Object)this.sceneMap.get((Object)"mainGameScene"));
    }

    public StartupScene getStartupScene(double width, double heigth) {
        if (!this.sceneMap.containsKey((Object)"startupScene")) {
            this.sceneMap.put((Object)"startupScene", (Object)((StartupScene)((Object)this.context.getBean("startupScene", new Object[]{width, heigth}))));
        }
        return (StartupScene)((Object)this.sceneMap.get((Object)"startupScene"));
    }

    public HanseaticHistoryScene getHanseaticHistoryScene(double width, double heigth) {
        if (!this.sceneMap.containsKey((Object)"hanseaticHistoryScene")) {
            this.sceneMap.put((Object)"hanseaticHistoryScene", (Object)((HanseaticHistoryScene)((Object)this.context.getBean("hanseaticHistoryScene", new Object[]{width, heigth}))));
        }
        return (HanseaticHistoryScene)((Object)this.sceneMap.get((Object)"hanseaticHistoryScene"));
    }

    public CreditsScene getCreditsScene(double width, double heigth) {
        if (!this.sceneMap.containsKey((Object)"creditsScene")) {
            this.sceneMap.put((Object)"creditsScene", (Object)((CreditsScene)((Object)this.context.getBean("creditsScene", new Object[]{width, heigth}))));
        }
        return (CreditsScene)((Object)this.sceneMap.get((Object)"creditsScene"));
    }

    public NewGameScene getNewGameScene(double width, double heigth) {
        if (!this.sceneMap.containsKey((Object)"newGameScene")) {
            RandomNameLoader firstNameLoader = (RandomNameLoader)this.context.getBean("firstNameLoader");
            RandomNameLoader lastNameLoader = (RandomNameLoader)this.context.getBean("lastNameLoader");
            NewGameScene newGameScene = (NewGameScene)((Object)this.context.getBean("newGameScene", new Object[]{width, heigth, firstNameLoader, lastNameLoader}));
            newGameScene.setSceneChangeable(OpenPaticianApplicationWindow.getApplication());
            this.sceneMap.put((Object)"newGameScene", (Object)newGameScene);
        }
        return (NewGameScene)((Object)this.sceneMap.get((Object)"newGameScene"));
    }

    public InGameOptionsScene getInGameOptionsScene(double width, double heigth) {
        if (!this.sceneMap.containsKey((Object)"inGameOptionsScene")) {
            this.sceneMap.put((Object)"inGameOptionsScene", (Object)((InGameOptionsScene)((Object)this.context.getBean("inGameOptionsScene", new Object[]{width, heigth}))));
        }
        return (InGameOptionsScene)((Object)this.sceneMap.get((Object)"inGameOptionsScene"));
    }

    public IJavaFXControlLoader getJavaFXControlLoader() {
        return this.jfxControlLoader;
    }

    private class JavaFXControlLoader
    implements IJavaFXControlLoader {
        private JavaFXControlLoader() {
        }

        @Override
        public MiniMap getMiniMap() {
            return (MiniMap)((Object)UIFactory.this.context.getBean("miniMap"));
        }

        @Override
        public MainMenu getMainMenu() {
            return (MainMenu)((Object)UIFactory.this.context.getBean("mainMenu"));
        }

        @Override
        public SubMenu getSubMenu() {
            return (SubMenu)UIFactory.this.context.getBean("subMenu");
        }

        @Override
        public NoticeBoard getNoticeBoard() {
            NoticeBoard noticeBoard = (NoticeBoard)UIFactory.this.context.getBean(NoticeBoard.class);
            noticeBoard.setFont(this.getFontLoader().createDefaultFont(18));
            return noticeBoard;
        }

        @Override
        public ViewStatus getViewStatus() {
            return (ViewStatus)UIFactory.this.context.getBean("viewStatus");
        }

        @Override
        public IFontLoader getFontLoader() {
            return (IFontLoader)UIFactory.this.context.getBean(FontLoader.class);
        }

        @Override
        public GameStatus getGameStatus() {
            return (GameStatus)UIFactory.this.context.getBean(GameStatus.class);
        }

        @Override
        public MainGameView getMainGameView(double width, double heigth) {
            Object[] args = new Object[]{width, heigth};
            return (MainGameView)UIFactory.this.context.getBean("mainGameView", args);
        }
    }
}

