package ch.sahits.game.event.data;

import ch.sahits.game.openpatrician.model.city.ICity;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;

import java.util.List;

import static java.util.Arrays.asList;

/**
* @author Andi Hotz, (c) Sahits GmbH, 2014
*         Created on Feb 16, 2014
*/
public class CourierPatrolStateInternal {
    private final int premium;
    private List<ICity> cities = Lists.newArrayList();
    public CourierPatrolStateInternal(int premium, ICity[] destinations) {
        super();
        this.premium = premium;
        cities.addAll(asList(destinations));
    }
    public int getPremium() {
        return premium;
    }
    public void removeFirstCity() {
        cities.remove(0);
    }
    public Optional<ICity> nextDestination() {
        if (cities.isEmpty()) {
            return Optional.absent();
        } else {
            return Optional.of(cities.get(0));
        }
    }
}
