package ch.sahits.game.event.data;

import ch.sahits.game.openpatrician.model.city.ICity;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * Patrol state.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 21, 2014
 */
public class PatrolInternalState {
    private final int premium;
    private final int bonusPerAttack;
    private int numberOfAttacks = 0;
    private List<ICity> cities = Lists.newArrayList();
    public PatrolInternalState(int premium, int bonusPerAttack, ICity[] destinations) {
        super();
        this.premium = premium;
        cities = Lists.newArrayList(destinations);
        this.bonusPerAttack = bonusPerAttack;
    }
    public int getPremium() {
        return premium;
    }
    public int getBonusPerAttack() {
        return bonusPerAttack;
    }
    public int getNumberOfAttacks() {
        return numberOfAttacks;
    }
    public void incAttackCounter() {
        numberOfAttacks++;
    }
    public void removeFirstCity() {
        cities.remove(0);
    }
    public Optional<ICity> nextDestination() {
        if (cities.isEmpty()) {
            return Optional.absent();
        } else {
            return Optional.of(cities.get(0));
        }
    }}
