package ch.sahits.game.event.handler;

import ch.sahits.game.event.data.NewGameClient;
import ch.sahits.game.javafx.control.GameStatus;
import ch.sahits.game.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Jan 18, 2014
 */
@LazySingleton
public class StartNewGameHandler {
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private GameStatus gameStatus;
    @Autowired
    private ViewStatus viewStatus;

    @PostConstruct
    private void initializeEventSystem() {
        clientServerEventBus.register(this);
    }
    @Subscribe
    public void handleNewGameStart(NewGameClient newGameDTO) {
        gameStatus.bindToPlayer(newGameDTO.getPlayer());
        viewStatus.setCity(newGameDTO.getPlayer().getHometown().getName());
    }

}
