package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.ShipAttackEvent;
import ch.sahits.game.event.data.PatrolInternalState;
import ch.sahits.game.event.handler.IAttackListener;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 21, 2014
 */
@Prototype
class AttackListener implements IAttackListener {
    private final IShip ship;
    private final PatrolInternalState state;
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    public AttackListener(IShip ship, PatrolInternalState state) {
        super();
        this.ship = ship;
        this.state = state;
    }
    @PostConstruct
    private void initializeEventBus() {
        clientServerEventBus.register(this);
    }

    @Subscribe
    public void handleShipAttack(ShipAttackEvent event) {
        if (event.getAttackedShip().equals(ship)) {
            state.incAttackCounter();
        }
    }
}
