package ch.sahits.game.event.handler.impl;

import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.Random;

/**
 * Event handler for delivering packages
 */
@Prototype
class DeliverPackages extends WaitTimeForShipArrivalInCity {
    private final int amount;
    private final int premium;
    @Autowired
    private Random rnd;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public DeliverPackages(ICity city, IShip ship, DateTime deadline, int premium, int amount) {
        super(city, ship, deadline);
        this.premium = premium;
        this.amount = amount;
    }

    @PostConstruct
    private void initializeEventBus() {
        clientServerEventBus.register(this);
    }
    @Override
    public boolean execute() {
        getShip().setOccupiedSpace(getShip().getOccupiedSpace() - amount);
        IPlayer owner = getShip().getOwner();
        if (rnd.nextBoolean()) {
            int penalty = (int)(Math.abs(owner.getCash()/200*rnd.nextDouble()));
            String s = messageSource.getMessage("ch.sahits.game.event.handler.impl.DeliverPackages.messageCaught", new Object[]{penalty}, locale.getCurrentLocal());
            DisplayMessage msg = new DisplayMessage(s,messageSource.getMessage("ch.sahits.game.graphic.event.task.DelayedCaughtAction.message2", new Object[]{penalty}, locale.getCurrentLocal()));
            clientEventBus.post(msg);
            owner.getCompany().updateCash(-penalty);
        } else {
            owner.getCompany().updateCash(premium);
            DisplayMessage msg = new DisplayMessage(messageSource.getMessage("ch.sahits.game.event.handler.impl.DeliverPackages.messageSuccess", new Object[]{}, locale.getCurrentLocal()));
            clientEventBus.post(msg);
        }
        return false;
    }
    @Override
    public void destroy() {
        getShip().setOccupiedSpace(getShip().getOccupiedSpace() - amount);
        super.destroy();
    }

}
