package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;

import javax.annotation.PostConstruct;

/**
 * Unload the anonymous ware upon arrival in the city
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 20, 2014
 */
@Prototype
public class UnloadOnArival extends ShipEntersPortEventListener {
    private final int amountLoaded;
    public UnloadOnArival(IShip ship, ICity city, int loaded) {
        super(ship, city);
        this.amountLoaded = loaded;
    }
    @PostConstruct
    private void initializeEventBus() {
        clientServerEventBus.register(this);
    }

    @Override
    public boolean execute() {
        getShip().setOccupiedSpace(getShip().getOccupiedSpace() - amountLoaded);
        clientServerEventBus.unregister(this);
        return true;
    }
}
