package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.control.PlaceHolder;
import ch.sahits.game.openpatrician.dialog.Dialog;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.util.Iterator;

/**
 * Basic dialog with a close button and a title.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Nov 15, 2013
 *
 */
public class CloseButtonDialog extends Dialog {
    @Autowired
    @Qualifier("clientEventBus")
    protected AsyncEventBus clientEventBus;

	private static final int CLOSE_BUTTON_HEIGHT = 24;
	private static final int CLOSE_BUTTON_WIDTH = 62;
	private static final int CLOSE_BUTTON_PADDING = 40;
    public static final int CLOSE_BTN_Y_POS = HEIGHT - CLOSE_BUTTON_HEIGHT - CLOSE_BUTTON_PADDING;
	private StringProperty title;
	private StringProperty closeLabel;
	public CloseButtonDialog(Font font) {
		super(font);
		title = new SimpleStringProperty(this,"title", "");
		closeLabel = new SimpleStringProperty(this,"closeLabel", "");
		Label titleLbl = new Label();
		titleLbl.getStyleClass().add("dialogTitle");
		titleLbl.textProperty().bind(title);
		titleLbl.setFont(font);
		StackPane titlePane = new StackPane();
		titlePane.setLayoutY(2*FRAME_BORDER);
		titlePane.getChildren().addAll(new PlaceHolder(WIDTH, 1), titleLbl);
		getContent().add(titlePane);
		OpenPatricianSmallWaxButton closeButton = new OpenPatricianSmallWaxButton("X", font);
		closeButton.setLayoutX(WIDTH - CLOSE_BUTTON_WIDTH - CLOSE_BUTTON_PADDING);
		closeButton.setLayoutY(CLOSE_BTN_Y_POS);
		closeButton.setOnAction(new EventHandler<MouseEvent>() {

			@Override
			public void handle(MouseEvent event) {
				executeOnCloseButtonClicked();
			}
		});
		closeButton.getStyleClass().add("buttonLabel");
		getContent().add(closeButton);
	}
	
	public StringProperty titleProperty() {
		return title;
	}
	public String getTitle() {
		return title.get();
	}
	public void setTitle(String title) {
		this.title.set(title);
	}

	public void removeDecoratedContent() {
		for (Iterator<Node> iterator = getContent().iterator(); iterator.hasNext(); ) {
			final Node child = iterator.next();
			if (child instanceof DecoratedText) {
				Platform.runLater(new Runnable() {
					@Override
					public void run() {
						getContent().remove(child);
					}
				});
			}
		}
	}
	public StringProperty closeLabelProperty() {
		return closeLabel;
	}
	public String getCloseLabel() {
		return closeLabel.get();
	}
	public void setCloseLabel(String closeLabel) {
		this.closeLabel.set(closeLabel);
	}
	/**
	 * Add the additional buttons evenly spaced to the left of the close button.
	 * @param buttons
	 */
	public void addButtomControlButtons(OpenPatricianSmallWaxButton...buttons) {
		double availableSpace = WIDTH - CLOSE_BUTTON_WIDTH - 2*CLOSE_BUTTON_PADDING;
		double widthButtonAndGap = availableSpace/buttons.length;
		Preconditions.checkState(widthButtonAndGap >= CLOSE_BUTTON_WIDTH, "Cannot draw buttons as there is not enough space");
		double gap = widthButtonAndGap - CLOSE_BUTTON_WIDTH;
		double x = CLOSE_BUTTON_PADDING;
		for (OpenPatricianSmallWaxButton btn : buttons) {
			btn.setLayoutX(x);
			btn.setLayoutY(HEIGHT - CLOSE_BUTTON_HEIGHT - CLOSE_BUTTON_PADDING);
			x += CLOSE_BUTTON_WIDTH + gap;
			getContent().add(btn);
		}
		
	}

	protected void executeOnCloseButtonClicked() {
        ViewChangeEvent event = new ViewChangeEvent(MainGameView.class, EViewChangeEvent.CLOSE_DIALOG);
        clientEventBus.post(event);
    }
}
