package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.graphic.display.dialog.util.DialogUtil;
import ch.sahits.game.javafx.control.BarrelAmount;
import ch.sahits.game.javafx.control.OpenPatricianDialogInput;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * Dialog for renaming a ship.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 18, 2013
 */
@Component("shipyardRenameDialog")
@Scope(value = "prototype")
public class ShipyardRenameDialogV2 extends BaseShipyardDialog {
    private ObjectProperty<IShip> currentShip;
    private StringProperty shipName;
    private OpenPatricianDialogInput shipNameInput;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private Locale locale;

    @Autowired
    private MessageSource messageSource;


    public ShipyardRenameDialogV2(Font font,final ICityPlayerProxyJFX city) {
        super(font, city);
        this.currentShip = new SimpleObjectProperty<>(this, "currentShip", city.getActiveShip());
        shipName = new SimpleStringProperty(this, "shipName", city.getActiveShip().getName());
        for (int i = 0; i < shipTypes.length; i++) {
            if (shipTypes[i] == currentShip.get().getShipType()) {
                currentShipTypeIndexProperty().set(i);
                break;
            }
        }
    }
    @PostConstruct
    private void init() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardRenameDialogV2.title", new Object[]{}, locale.getCurrentLocal()));
        this.enablePreviousNext = dialogUtil.enableShipCatalogue(city);
    }

    @Override
    protected String getActionText() {
        return messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardRenameDialogV2.rename", new Object[]{}, locale.getCurrentLocal());
    }
    @Override
    protected boolean hasShips() {
        return city.getPlayersShips().size() > 0;
    }

    @Override
    protected EventHandler<MouseEvent> getAction() {
        return new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                currentShip.get().setName(shipName.get());
                executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected Group createFooterText() {
        return new Group();
    }

    @Override
    protected Table createMainTable() {
        Table model = new Table();
        // Add dummy header which is not rendered
        TableHeader header = new TableHeader(2);
        header.add(new StaticTextTableCell(""));
        header.add(new StaticTextTableCell(""));

        model.setHeader(header);
        model.setColumnWidth(150, 200);
        TableRow row = new TableRow();

        row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardRenameDialogV2.shipName", new Object[]{}, locale.getCurrentLocal())));
        shipNameInput = new OpenPatricianDialogInput(font);
        shipNameInput.textProperty().bindBidirectional(shipName);
        row.add(new ControlTableCell(shipNameInput));
        model.add(row);
        return model;
    }

    @Override
    protected BooleanBinding actionEnabledBinding() {
        return new BooleanBinding() {
            {
                super.bind(shipName);
            }
            @Override
            protected boolean computeValue() {
                return shipName.get() != getActiveShip().getName();
            }
        };
    }

    @Override
    protected RowConstraints getRowConstraints() {
        return new RowConstraints(36);
    }

    @Override
    protected Table createTopTable() {
        Table model = new Table();
        // Add dummy header which is not rendered
        TableHeader header = new TableHeader(3);
        model.setHeader(header);
        model.setColumnWidth(70, 70, 70);
        TableRow row = new TableRow();
        BarrelAmount capacityAmount = new BarrelAmount(font);
        capacityAmount.setAmount(currentShip.get().getSize());
        row.add(new ControlTableCell(capacityAmount));

        row.add(new StaticTextTableCell(String.valueOf(100 - currentShip.get().getDamage())));
        row.add(new StaticTextTableCell(String.valueOf(currentShip.get().getNumberOfSailors())));
        model.add(row);
        return model;
    }
    @Override
    protected EventHandler<MouseEvent> createNextAction() {
        return dialogUtil.createNextAction(city, currentShip);
    }

    @Override
    protected EventHandler<MouseEvent> createPreviousAction() {
        return dialogUtil.createPreviousAction(city, currentShip);
    }
}
