package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.image.impl.XMLImageLoader;
import ch.sahits.game.javafx.control.BaleIconView;
import ch.sahits.game.javafx.control.BarrelIconView;
import ch.sahits.game.javafx.control.CoinIconView;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ELevel;
import ch.sahits.game.openpatrician.model.building.IStorage;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;

/**
 * Dialog giving an overview on the storage and warehouses.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Dec 7, 2013
 *
 */
@Prototype
public class StorageOverviewDialog extends TabelViewDialog {
	/** Reference to the city view model */
	protected final ICityPlayerProxyJFX city;
	
	private final Font font;
	@Autowired
	@Qualifier("mainScreenXMLImageLoader")
	private XMLImageLoader imageLoader;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
	@Autowired
	private Locale locale;

	@Autowired
	private MessageSource messageSource;

	public StorageOverviewDialog(Font font,
			ICityPlayerProxyJFX city) {
		super(font);
		this.city = city;
		this.font = font;
	}
	
	@Override
	protected void executeOnCloseButtonClicked() {
        clientEventBus.post(new NoticeBoardClose());
		super.executeOnCloseButtonClicked();
	}
	@PostConstruct
	private void initializeModelAndDialog() {
		setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog.storage", new Object[]{}, locale.getCurrentLocal()));
		Table model = createModel();
		setModel(model);
	}

	private Table createModel() {
		final ITradingOffice office = city.getPlayer().findTradingOffice(city.getCity());
		final IStorage storage = office.getStorage();
		
    	Table model = new Table();
    	TableHeader header = new TableHeader(4);
    	header.add(new StaticTextTableCell(""));
    	header.add(new StaticTextTableCell(""));
    	header.add(new StaticTextTableCell(""));
    	header.add(new StaticTextTableCell(""));
        model.setHeader(header);
        model.setAligenment(0, HPos.LEFT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.RIGHT);
        model.setAligenment(3, HPos.LEFT);
    	model.setColumnWidth(210, 120, 30, 30);
    	
		TableRow row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.requiredCapacity", new Object[]{}, locale.getCurrentLocal())));
		row.add(new StaticTextTableCell(""));
		Text amount = new Text();
		amount.setFont(font);
		amount.textProperty().bind(office.storedAmountBinding().divide(10).asString());
		row.add(new ControlTableCell(amount));
		
		BaleIconView baleAmount = new BaleIconView();
		row.add(new ControlTableCell(baleAmount));
		model.add(row);

		row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.availableCap", new Object[]{}, locale.getCurrentLocal())));
		row.add(new StaticTextTableCell(""));
		Text capacityTxt = new Text();
		capacityTxt.setFont(font);
		capacityTxt.textProperty().bind(office.capacityProperty().asString());
		row.add(new ControlTableCell(capacityTxt));
		baleAmount = new BaleIconView();
		row.add(new ControlTableCell(baleAmount));
		model.add(row);

		row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.additionalCap", new Object[]{}, locale.getCurrentLocal())));
		row.add(new StaticTextTableCell(""));
		IntegerBinding additionalAmount = new IntegerBinding() {
			{
				super.bind(office.storedAmountBinding(), office.capacityProperty());
			}
			
			@Override
			protected int computeValue() {
				return Math.max(office.storedAmountBinding().subtract(office.capacityProperty()).intValue(), 0);
			}
		};
		Text additionalAmountTxt = new Text();
		additionalAmountTxt.setFont(font);
		additionalAmountTxt.textProperty().bind(additionalAmount.asString());
		row.add(new ControlTableCell(additionalAmountTxt));
		baleAmount = new BaleIconView();
		row.add(new ControlTableCell(baleAmount));
		model.add(row);

		row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.otherGoods", new Object[]{}, locale.getCurrentLocal())));
		row.add(new StaticTextTableCell(""));
		Text otherTxt = new Text();
		otherTxt.setFont(font);
		otherTxt.textProperty().bind(storage.rentOutStorageProperty().asString());
		row.add(new ControlTableCell(otherTxt));
		BarrelIconView barrelAmount = new BarrelIconView();
		row.add(new ControlTableCell(barrelAmount));
		model.add(row);

		row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.costs", new Object[]{}, locale.getCurrentLocal())));
		row.add(new StaticTextTableCell(""));
		Text storageCosts = new Text();
		storageCosts.setFont(font);
		storageCosts.textProperty().bind(storage.costsPerDayBinding().asString());
		row.add(new ControlTableCell(storageCosts));
		CoinIconView coinAmount = new CoinIconView();
		row.add(new ControlTableCell(coinAmount));
		model.add(row);
		
		addEmptyRow(model);
		addEmptyRow(model);
		
		row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.guards", new Object[]{}, locale.getCurrentLocal())));
		row.add(new StaticTextTableCell(""));
		row.add(new StaticTextTableCell(""));
		row.add(new StaticTextTableCell(""));
		model.add(row);
	
		row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.noGuards", new Object[]{}, locale.getCurrentLocal())));
		Image minus = imageLoader.getImage("minusIcon");
		ImageView minusView = new ImageView(minus);
		Label minusLbl = new Label("", minusView);
		minusLbl.setOnMouseReleased(new EventHandler<MouseEvent>() {
			@Override
			public void handle(MouseEvent arg0) {
				storage.updateGuardsNumber(-1);
			}
		});
		row.add(new ControlTableCell(minusLbl));
		Text nbGuardsTxt = new Text();
		nbGuardsTxt.setFont(font);
		nbGuardsTxt.textProperty().bind(storage.numberGuardsProperty().asString());
		row.add(new ControlTableCell(nbGuardsTxt));
		Image plus = imageLoader.getImage("plusIcon");
		ImageView plusView = new ImageView(plus);
		Label plusLbl = new Label("", plusView);
		plusLbl.setOnMouseReleased(new EventHandler<MouseEvent>() {
			@Override
			public void handle(MouseEvent arg0) {
				storage.updateGuardsNumber(1);
			}
		});

		row.add(new ControlTableCell(plusLbl));
		model.add(row);
		
		row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.costs", new Object[]{}, locale.getCurrentLocal())));
		row.add(new StaticTextTableCell(""));
		Text guardsCosts = new Text();
		guardsCosts.setFont(font);
		guardsCosts.textProperty().bind(storage.guardCostsPerDayBinding().asString());
		row.add(new ControlTableCell(guardsCosts));
		coinAmount = new CoinIconView();
		row.add(new ControlTableCell(coinAmount));
		model.add(row);

		row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.StorageOverviewDialog.security", new Object[]{}, locale.getCurrentLocal())));
		row.add(new StaticTextTableCell(""));
		Text securityTxt = new Text();
		securityTxt.setFont(font);
		securityTxt.textProperty().bind(new LevelBinding(storage.securityLevelBinding()));
		row.add(new ControlTableCell(securityTxt));
		row.add(new StaticTextTableCell(""));
		model.add(row);

		return model;
	}

	private void addEmptyRow(Table model) {
		TableRow row;
		row = new TableRow();
		row.add(new StaticTextTableCell(""));
		row.add(new StaticTextTableCell(""));
		row.add(new StaticTextTableCell(""));
		row.add(new StaticTextTableCell(""));
		model.add(row);
	}
	private static class LevelBinding extends StringBinding {
		private final ObjectBinding<ELevel> levelBinding;
		LevelBinding(ObjectBinding<ELevel> levelBinding) {
			this.levelBinding = levelBinding;
			super.bind(levelBinding);
		}

		@Override
		protected String computeValue() {
			return levelBinding.get().name();
		}
		
	}

}
