package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.impl.ThieveState;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

import static com.google.common.collect.Lists.newArrayList;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 24, 2013
 */
@Prototype
public class TavernBurglarDialog extends TavernBaseSideRoomPersonDialog {
    public static final String DEFAULT_NON_SELECTED_STYLE = "-fx-fill: dimgray;";
    public static final String SELECTED_STYLE = "-fx-font-weight: bolder; -fx-fill: black;";
    private final List<IPlayer> residentOponents;
    private ObjectProperty<IPlayer> selectedOponent;
    @Autowired
    private Random rnd;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private ClientTaskFactory taskFactory;
    private BooleanBinding disabeAcceptBinding;

    @Autowired
    private ModelTranslations modelTranslator;

    public TavernBurglarDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, city.getCity().getCityState().getTavernState().getThieve());
        residentOponents = newArrayList();
        selectedOponent = new SimpleObjectProperty<>(this, "selectedOpponent", null);
        for (Iterator<IPlayer> iterator = city.getCity().getResidentPlayers().iterator(); iterator.hasNext(); ) {
            IPlayer player =  iterator.next();
            if (!player.equals(city.getPlayer())) {
                residentOponents.add(player);
            }
        }
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBurglarDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        VBox box = new VBox();
        box.setLayoutX(2*FRAME_BORDER);
        box.setLayoutY(100);
        Text intro = new Text();
        intro.setFont(font);
        StringBuilder sb = new StringBuilder();
        sb.append(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBurglarDialog.dialog1", new Object[]{}, locale.getCurrentLocal()));
        intro.setText(sb.toString());
        Text emptyLine = new Text(" ");
        emptyLine.setFont(font);
        box.getChildren().addAll(intro, emptyLine);
        final List<Text> opponents = newArrayList();
        for (IPlayer opponent : residentOponents) {
            sb = new StringBuilder();
            sb.append(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBurglarDialog.list",
                    new Object[]{modelTranslator.getLocalDisplayName(opponent.getCareerLevel()), modelTranslator.getLocalDisplayName(opponent.getRank()), opponent.getName(), opponent.getLastName(), opponent.getHometown().getName()}, locale.getCurrentLocal()));
            Text text = new Text(sb.toString());
            text.setFont(font);
            text.setUserData(opponent);
            text.setStyle(DEFAULT_NON_SELECTED_STYLE);
            box.getChildren().add(text);
            opponents.add(text);
        }
        for (final Text opponent : opponents) {
            opponent.setOnMouseReleased(new EventHandler<MouseEvent>() {
                @Override
                public void handle(MouseEvent mouseEvent) {
                    selectedOponent.set((IPlayer) opponent.getUserData());
                    disableAcceptButton().invalidate();
                    resetStyles(opponents);
                    opponent.setStyle(SELECTED_STYLE);
                }
            });
        }


        getContent().add(box);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                IPlayer player = city.getPlayer();
                ThieveState burglar = (ThieveState) currentPerson.get();
                player.getCompany().updateCash(-burglar.getPrice());
                int probability = rnd.nextInt(3);
                if (probability < 1) {
                    timedTaskListener.add((TimedTask)taskFactory.getDelayedCaughtAction(player));
                } else {
                    timedTaskListener.add((TimedTask)taskFactory.getBreakInAction(selectedOponent.get()));
                }
                burglar.leave();
                executeOnCloseButtonClicked();
            }
        };
    }

    /**
     * Remove the bold style from all Text elements.
     * @param texts list of text nodes that should have their style reset.
     */
    private void resetStyles(List<Text> texts) {
        for (Text text : texts) {
            text.setStyle(DEFAULT_NON_SELECTED_STYLE);
        }
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        if (disabeAcceptBinding == null) {
            disabeAcceptBinding = new BooleanBinding() {
                {
                    super.bind(selectedOponent);
                }

                @Override
                protected boolean computeValue() {
                    return !residentOponents.isEmpty() && selectedOponent.get() == null;
                }
            };
        }
        return disabeAcceptBinding;
    }


}
