package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IBalanceSheet;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ITownHouse;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWorkShop;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.binding.StringBinding;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.List;

/**
 * Dialog for the balance.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Dec 6, 2013
 *
 */
@Prototype
public class TradeOfficeBalanceDialog extends TabelViewDialog {
	private Font font;
	/** Reference to the city view model */
	protected final ICityPlayerProxyJFX city;
	@Autowired
	private Date date;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
	@Autowired
	private Locale locale;

	@Autowired
	private MessageSource messageSource;

	

	public TradeOfficeBalanceDialog(Font font, ICityPlayerProxyJFX city) {
		super(font);
		this.city = city;
		this.font = font;
	}
	private Group createSubTitle() {
		StringBinding fromTo = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return date.getStartOfWeek()+" to "+date.getEndOfWeek();
			}
		};
		Text fromToText = new Text();
		fromToText.textProperty().bind(fromTo);
		fromToText.setFont(font);
		fromToText.setLayoutX(100);
		
		Text forecast = new Text("Forecast");
		forecast.setFont(font);
		forecast.setLayoutX(350);
		Group g = new Group();
		g.setManaged(false);
		
		g.getChildren().addAll(fromToText, forecast);

		return g;
	}
	@PostConstruct
	private void initializeModelAndDialog() {
		setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.title", new Object[]{}, locale.getCurrentLocal()));
		// create the header as sub title
		Group subTitle = createSubTitle();
		subTitle.setLayoutX(2*FRAME_BORDER);
		subTitle.setLayoutY(80);
		getContent().add(subTitle);
		Table model = createModel();
		setModel(model);
	}
	private Table createModel() {
		ICity cityModel = city.getCity();
		final ITradingOffice office = city.getPlayer().findTradingOffice(cityModel);
		final List<IBuilding> workshops = city.getPlayer().findBuildings(cityModel, IWorkShop.class);
		final List<IBuilding> townhouse = city.getPlayer().findBuildings(cityModel, ITownHouse.class);
		Table model = new Table();
		TableHeader header = new TableHeader(5);
		header.add(new StaticTextTableCell(""));
		header.add(new StaticTextTableCell(""));
		header.add(new StaticTextTableCell(""));
		header.add(new StaticTextTableCell(""));
		header.add(new StaticTextTableCell(""));
    	header.setAligenment(0, HPos.RIGHT);
    	header.setAligenment(1, HPos.LEFT);
    	header.setAligenment(2, HPos.LEFT);
    	header.setAligenment(3, HPos.LEFT);
    	header.setAligenment(4, HPos.LEFT);
    	model.setHeader(header);
    	model.setColumnWidth(100, 50, 100, 50, 150);
    	TableRow row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.rentalIncome", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding rentalIncomeLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getRentalIncome());
			}
		};
		CoinPriceAlwaysVisible coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(rentalIncomeLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding rentalIncomeForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getCurrentWeek().getRentalIncome());
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(rentalIncomeForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.wages", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding wagesIncomeLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getWageCosts());
			}
		};
		coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(wagesIncomeLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding wagesIncomeForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getRentalIncome());
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(wagesIncomeForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);
		
		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.propertyTax", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding taxLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getPropertyTaxes());
			}
		};
		coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(taxLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding taxForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getPropertyTaxes());
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(taxForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.officeTrading", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding tradingLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getOfficeTrading());
			}
		};
		coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(tradingLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding tradingForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getOfficeTrading());
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(tradingForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.steward", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding stewardLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getStewardCost());
			}
		};
		coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(stewardLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding stewardForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getStewardCost());
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(stewardForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.other", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding otherLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getOtherCosts());
			}
		};
		coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(otherLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding otherForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getOtherCosts());
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(otherForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.sum", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding sumLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				IBalanceSheet bal = office.getBalanceLastWeek();
				int lastWeek =0;
				lastWeek += bal.getOtherCosts() + bal.getPropertyTaxes() + bal.getStewardCost() + bal.getWageCosts();
				lastWeek -= (bal.getOfficeTrading() + bal.getRentalIncome());
				return String.valueOf(lastWeek);
			}
		};
		coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(sumLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding sumForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				int forcast = 0;
				IBalanceSheet bal = office.getCurrentWeek();
				forcast += bal.getOtherCosts() + bal.getPropertyTaxes() + bal.getStewardCost() + bal.getWageCosts();
				forcast -= (bal.getOfficeTrading() + bal.getRentalIncome());
				return String.valueOf(forcast);
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible(font);
		coinPrice.amountProperty().bind(sumForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
		model.add(row);

		row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.buildings", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
		model.add(row);
		
		row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.workshops", new Object[]{}, locale.getCurrentLocal())));
    	Text nbWorkshops = new Text();
    	nbWorkshops.setFont(font);
    	StringBinding nbWsBinding = new DateBoundStringProperty() {
			
			@Override
			protected String computeValue() {
				return String.valueOf(workshops.size());
			}
		};
		nbWorkshops.textProperty().bind(nbWsBinding);
    	row.add(new ControlTableCell(nbWorkshops));
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.workers", new Object[]{}, locale.getCurrentLocal())));
    	Text nbWorkers = new Text();
    	nbWorkers.setFont(font);
    	StringBinding nbWBinding = new DateBoundStringProperty() {
			
			@Override
			protected String computeValue() {
				int people = 0;
				for (IBuilding building : workshops) {
					people += ((IWorkShop)building).getWorkers();
				}
				return String.valueOf(people);
			}
		};
		nbWorkers.textProperty().bind(nbWBinding);
    	row.add(new ControlTableCell(nbWorkers));
    	Text nbWorkersMax = new Text();
    	nbWorkersMax.setFont(font);
    	StringBinding nbWBindingMax = new DateBoundStringProperty() {
			
			@Override
			protected String computeValue() {
				int maxPeople = 0;
				for (IBuilding building : workshops) {
					maxPeople += ((IWorkShop)building).getMaxWorkers();
				}
				return "(max. " + String.valueOf(maxPeople) + ")";
			}
		};
		nbWorkersMax.textProperty().bind(nbWBindingMax);
    	row.add(new ControlTableCell(nbWorkersMax));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.tenements", new Object[]{}, locale.getCurrentLocal())));
    	Text nbhouses = new Text();
    	nbhouses.setFont(font);
    	StringBinding nbHouseBinding = new DateBoundStringProperty() {
			
			@Override
			protected String computeValue() {
				return String.valueOf(townhouse.size());
			}
		};
		nbhouses.textProperty().bind(nbHouseBinding);
    	row.add(new ControlTableCell(nbhouses));
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.tenants", new Object[]{}, locale.getCurrentLocal())));
    	Text nbTenants = new Text();
    	nbTenants.setFont(font);
    	StringBinding nbTBinding = new DateBoundStringProperty() {
			
			@Override
			protected String computeValue() {
				int people = 0;
				for (IBuilding building : townhouse) {
					people += ((ITownHouse)building).getOccupancy();
				}
				return String.valueOf(people);
			}
		};
		nbTenants.textProperty().bind(nbTBinding);
    	row.add(new ControlTableCell(nbTenants));
    	Text nbTenantsMax = new Text();
    	nbTenantsMax.setFont(font);
    	StringBinding nbTBindingMax = new DateBoundStringProperty() {
			
			@Override
			protected String computeValue() {
				int maxPeople = 0;
				for (IBuilding building : townhouse) {
					maxPeople += ((ITownHouse)building).getCapacity();
				}
				return messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog.maxPeople", new Object[]{String.valueOf(maxPeople)}, locale.getCurrentLocal());
			}
		};
		nbTenantsMax.textProperty().bind(nbTBindingMax);
    	row.add(new ControlTableCell(nbTenantsMax));
		model.add(row);

		
		return model;
	}
	@Override
	protected void executeOnCloseButtonClicked() {
        clientEventBus.post(new NoticeBoardClose());
		super.executeOnCloseButtonClicked();
	}
	
	private abstract class DateBoundStringProperty extends StringBinding {
		{
			super.bind(date.getCurrentDateProperty());
		}
	}

}
