package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.javafx.control.BaleAmount;
import ch.sahits.game.javafx.control.BarrelAmount;
import ch.sahits.game.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.IStorage;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.IntegerProperty;
import javafx.geometry.HPos;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 13, 2013
 */
@Prototype
public class WareInStockDialog extends TabelViewDialog {
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    private static final IntegerBinding ONE_INT_BINDING = new IntegerBinding() {
        @Override
        protected int computeValue() {
            return 1;
        }
    };
    /** Reference to the city view model */
    private final ICityPlayerProxyJFX city;
    private final Font font;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;

    public WareInStockDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
    }
    @Override
    protected void executeOnCloseButtonClicked() {
        clientEventBus.post(new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }
    @PostConstruct
    private void initializeModelAndDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.WareInStockDialog.title", new Object[]{}, locale.getCurrentLocal()));
        Table model = createModel();
        setModel(model);
    }

    private Table createModel() {
        final ITradingOffice office = city.getPlayer().findTradingOffice(city.getCity());
        final IStorage storage = office.getStorage();
        Table model = new Table();
        TableHeader header = new TableHeader(4);
        header.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ware", new Object[]{}, locale.getCurrentLocal())));
        header.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.WareInStockDialog.stockInCity", new Object[]{}, locale.getCurrentLocal())));
        header.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.WareInStockDialog.fromCity", new Object[]{}, locale.getCurrentLocal())));
        header.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.WareInStockDialog.toCity", new Object[]{}, locale.getCurrentLocal())));
        header.setAligenment(0, HPos.RIGHT);
        header.setAligenment(1, HPos.CENTER);
        header.setAligenment(2, HPos.CENTER);
        header.setAligenment(3, HPos.CENTER);
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.RIGHT);
        model.setAligenment(3, HPos.RIGHT);
        model.setColumnWidth(100, 100, 100, 100);
        for (EWare ware : EWare.values()) {
            TableRow row = new TableRow();
            row.add(new StaticTextTableCell(translator.getLocalDisplayName(ware)));

            AmountablePrice<IWare> available = city.getCity().getWare(ware);
            IntegerProperty storedAmountProperty = available.amountProperty();
            if (ware.isBarrelSizedWare()) {
                BarrelAmount barrelAmount = new BarrelAmount(font);
                barrelAmount.amountProperty().bind(storedAmountProperty.asString());
                row.add(new ControlTableCell(barrelAmount));
            } else {
                BaleAmount baleAmount = new BaleAmount(font);
                baleAmount.amountProperty().bind(storedAmountProperty.asString());
                row.add(new ControlTableCell(baleAmount));
            }

            CoinPriceAlwaysVisible buyPrice = new CoinPriceAlwaysVisible(font);
            buyPrice.amountProperty().bind(buyPrice(ware, storedAmountProperty));
            row.add(new ControlTableCell(buyPrice));

            CoinPriceAlwaysVisible sellPrice = new CoinPriceAlwaysVisible(font);
            sellPrice.amountProperty().bind(sellPrice(ware, storedAmountProperty));
            row.add(new ControlTableCell(sellPrice));


            model.add(row);
        }

        return model;
    }
    /**
     * Create the binding for the buy price for the indicated ware.
     * @param ware
     * @param availableAmount
     * @return
     */
    private StringBinding buyPrice(final IWare ware, final IntegerProperty availableAmount) {
        return new StringBinding() {
            {
                super.bind(availableAmount);
            }

            @Override
            protected String computeValue() {
                            return String.valueOf(ware.buyPrice(availableAmount, ONE_INT_BINDING));
            }
        };
    }
    /**
     * Create a binding for the sell price for the indicated ware.
     * @param ware
     * @param availableAmount
     * @return
     */
    private StringBinding  sellPrice(final IWare ware, final IntegerProperty availableAmount) {
        return new StringBinding() {
            {
                super.bind(availableAmount);
            }
            @Override
            protected String computeValue() {
                  return String.valueOf(ware.sellPrice(availableAmount, ONE_INT_BINDING));
            }
        };
    }
}
