package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.IWare;
import javafx.beans.property.SimpleIntegerProperty;

/**
 * Action of selling stuff to the city from the ship
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Nov 23, 2011
 *
 */
class Ship2CityJFXAction implements Runnable{
	private final IWare ware;
	private final ITransferableJFX dialog;
//	private static final Logger logger = Logger.getLogger(Ship2CityAction.class.getName());

	public Ship2CityJFXAction(IWare ware, ITransferableJFX dialog) {
		super();
		this.ware = ware;
		this.dialog=dialog;
	}

	@Override
	public void run() {
		ICityPlayerProxyJFX city = dialog.getCityPlayerProxy();
		int amountOnShip = city.getActiveShip().getWare(ware).getAmount();
		if (amountOnShip>0){
			int availableAmountCity = city.getCity().getWare(ware).getAmount();
			int amount2Move = dialog.getAmount(amountOnShip);
			final int avgPrice;
			if (dialog.getMovableAmount()==ETransferAmount.MAX){
				avgPrice = ware.getMaxValueSell();
			} else {
				avgPrice = ware.sellPrice(new SimpleIntegerProperty(availableAmountCity), new ConstantIntegerBinding(amount2Move));
			}
			city.getCity().move(ware, amount2Move,city.getPlayer()); // The price here is irrelevant
			int sold = city.getActiveShip().unload(ware, -amount2Move);
			city.getPlayer().updateCash(avgPrice*sold);
		}
	}
}
