package ch.sahits.game.graphic.display.dialog.util;

import ch.sahits.game.graphic.display.dialog.*;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.openpatrician.dialog.Dialog;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.*;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class DialogFactory {
	@Autowired
	private ApplicationContext context;
	@Autowired
	private IFontLoader fontLoader;
	
	public Dialog getDialog(EDialogType dialogType, ICityPlayerProxyJFX cityProxy) {
		Font font = fontLoader.createDefaultFont(18);
		switch (dialogType) {
		case CITY_TO_SHIP:
			return (CityShipTradeDialog) context.getBean("cityShipTradeDialog", font, cityProxy);
		case CITY_TO_STORAGE:
			return (CityStorageTradeDialog) context.getBean("cityStorageTradeDialog", font, cityProxy);
		case STORAGE_TO_SHIP:
			return (StorageShipTradeDialog) context.getBean("storageShipTradeDialog", font, cityProxy);
		case TO_BALANCE:
			return (TradeOfficeBalanceDialog) context.getBean("tradeOfficeBalanceDialog", font, cityProxy);
		case TO_PERSONAL:
			return (PersonalDialog) context.getBean("personalDialog", font, cityProxy);
		case TO_CONSUMPTION_PRODUCTION:
        case MB_CONSUMPTION_PRODUCTION:
			return (CityProductionConsumtionDialog) context.getBean("cityProductionConsumtionDialog", font, cityProxy);
		case TO_WEAPONS:
			return (WeaponInventoryDialog) context.getBean("weaponInventoryDialog", font, cityProxy);
		case TO_WAREHOUSES:
			return (StorageOverviewDialog) context.getBean("storageOverviewDialog", font, cityProxy);
		case TO_OFFICE_TRADING:
			return (AutomaticTradingOverviewDialog) context.getBean("automaticTradingOverviewDialog", font, cityProxy);
        case MB_STOCK_PRICES:
            return (WareInStockDialog) context.getBean("wareInStockDialog", font, cityProxy);
        case SHIPYARD_CONSTRUCTION:
            return (ShipyardConstructionDialogV2) context.getBean("shipyardConstructionDialog", font, cityProxy);
        case SHIPYARD_REPAIR:
            return (ShipRepairDialogV2) context.getBean("shipRepairDialog", font, cityProxy);
        case SHIPYARD_CONSTRUCTION_LIST:
            return (ShipyardConstructionListDialogV2) context.getBean("shipyardConstructionListDialog", font, cityProxy);
        case SHIPYARD_REPAIR_LIST:
            return (ShipyardRepairListDialogV2) context.getBean("shipyardRepairListDialog", font, cityProxy);
        case SHIPYARD_UPGRADE:
            return (ShipyardUpgradeDialogV2) context.getBean("shipyardUpgradeDialog", font, cityProxy);
        case SHIPYARD_RENAME:
            return (ShipyardRenameDialogV2) context.getBean("shipyardRenameDialog", font, cityProxy);
        case TAVERN_SAILORS:
            return (TavernSailorDialog) context.getBean("tavernSailorDialog", font, cityProxy);
        case TAVERN_CAPTAIN:
            return (TavernCaptainDialog) context.getBean("tavernCaptainDialog", font, cityProxy);
        case TAVERN_WEAPONS_DEALER:
            return (TavernWeaponsDealerDialog) context.getBean("tavernWeaponsDealerDialog", font, cityProxy);
        case TAVERN_PIRATE:
            return (TavernPirateDialog) context.getBean("tavernPirateDialog", font, cityProxy);
        case TAVERN_TRADER:
            return (TavernTraderDialog) context.getBean("tavernTraderDialog", font, cityProxy);
        case TAVERN_TRAVELER:
            return (TavernTravelerDialog) context.getBean("tavernTravelerDialog", font, cityProxy);
        case TAVERN_TREASUREMAP_OWNER:
            return (TavernTreasureMapOwnerDialog) context.getBean("tavernTreasureMapOwnerDialog", font, cityProxy);
        case TAVERN_INFORMANT_1:
            return (TavernInformantDialogPageOne) context.getBean("tavernInformantDialogPageOne", font, cityProxy);
        case TAVERN_INFORMANT_2:
            return (TavernInformantDialogPageTwo) context.getBean("tavernInformantDialogPageTwo", font, cityProxy);
        case TAVERN_SIDE_ROOM:
        {
            final TavernState tavernState = cityProxy.getCity().getCityState().getTavernState();
            synchronized (tavernState) {
                ISideRoomPerson sideRoomPerson = tavernState.presentPersonsInSideRoomBinding().get().get(0);
                return createDialogForSideRoom(sideRoomPerson, font, cityProxy);
            }
        }
        case TAVERN_COURIER:
            return (TavernCourierDialog) context.getBean("tavernCourierDialog", font, cityProxy);
        case TAVERN_BURGLAR:
            return (TavernBurglarDialog) context.getBean("tavernBurglarDialog", font, cityProxy);
        case TAVERN_TRANSPORT_TRADER:
            return (TavernTransportTraderDialog) context.getBean("tavernTransportTraderDialog", font, cityProxy);
        case TAVERN_WAREHOUSE_TENANT:
            return (TavernWarehouseTenantDialog) context.getBean("tavernWarehouseTenantDialog", font, cityProxy);
        case TAVERN_SMUGGLER:
            return (TavernSmugglerDialog) context.getBean("tavernSmugglerDialog", font, cityProxy);
        case TAVERN_PIRATE_HUNTER:
            return (TavernPirateHunterDialog) context.getBean("tavernPirateHunterDialog", font, cityProxy);
        case TAVERN_PATROL:
            return (TavernPatrolDialog) context.getBean("tavernPatrolDialog", font, cityProxy);
        case TAVERN_BUYER:
            return (TavernBuyerDialog) context.getBean("tavernBuyerDialog", font, cityProxy);
        case TAVERN_CONCURRENT:
            return (TavernConcurrentDialog) context.getBean("tavernConcurrentDialog", font, cityProxy);
        case TAVERN_ESCORTE:
            return (TavernEscortDialog) context.getBean("tavernEscortDialog", font, cityProxy);
        case TAVERN_FUGATIVE:
            return (TavernFugativeDialog) context.getBean("tavernFugativeDialog", font, cityProxy);
        case LOANER_TAKE:
            return (LoanerTakeLoanDialog) context.getBean("loanerTakeLoanDialog", font, cityProxy);
        case LOANER_GIVE:
            return (LoanerGiveLoanDialog) context.getBean("loanerGiveLoanDialog", font, cityProxy);
        case LOANER_REPAY:
            return (LoanerPaybackDialog) context.getBean("loanerPaybackDialog", font, cityProxy);
        case LOANER_LIST:
            return (LoanerListLoansDialog) context.getBean("loanerListLoansDialog", font, cityProxy);
        default:
			throw new RuntimeException("Not yet implemented: "+dialogType);
		}
	}

    /**
     * Retrieve the dialog that matches the side room person
     * @param sideRoomPerson
     * @return
     */
    private Dialog createDialogForSideRoom(ISideRoomPerson sideRoomPerson, Font font, ICityPlayerProxyJFX cityProxy) {
        if (sideRoomPerson instanceof ICourier) {
            return (TavernCourierDialog) context.getBean("tavernCourierDialog", font, cityProxy);
        }
        if (sideRoomPerson instanceof IThieve) {
            return (TavernBurglarDialog) context.getBean("tavernBurglarDialog", font, cityProxy);
        }
        if (sideRoomPerson instanceof ITransportTrader) {
            return (TavernTransportTraderDialog) context.getBean("tavernTransportTraderDialog", font, cityProxy);
        }
        if (sideRoomPerson instanceof IWarehouseTenant) {
            return (TavernWarehouseTenantDialog) context.getBean("tavernWarehouseTenantDialog", font, cityProxy);
        }
        if (sideRoomPerson instanceof ISmuggler) {
            return (TavernSmugglerDialog) context.getBean("tavernSmugglerDialog", font, cityProxy);
        }
        if (sideRoomPerson instanceof IPirateHunter) {
            return (TavernPirateHunterDialog) context.getBean("tavernPirateHunterDialog", font, cityProxy);
        }
        if (sideRoomPerson instanceof IPatrol) {
            return (TavernPatrolDialog) context.getBean("tavernPatrolDialog", font, cityProxy);
        }
        if (sideRoomPerson instanceof IBuyer) {
            return (TavernBuyerDialog) context.getBean("tavernBuyerDialog", font, cityProxy);
        }
        if (sideRoomPerson instanceof  IConcurrent) {
            return (TavernConcurrentDialog) context.getBean("tavernConcurrentDialog", font, cityProxy);
        }
        if (sideRoomPerson instanceof IEscorte) {
            return (TavernEscortDialog) context.getBean("tavernEscortDialog", font, cityProxy);
        }
        if (sideRoomPerson instanceof IFugitive) {
            return (TavernFugativeDialog) context.getBean("tavernFugativeDialog", font, cityProxy);
        }
        if (sideRoomPerson instanceof ITreasureMapOwner) {
            return (TavernTreasureMapOwnerDialog) context.getBean("tavernTreasureMapOwnerDialog", font, cityProxy);
        }
        throw new RuntimeException("Not yet implemented: "+sideRoomPerson.getClass().getName());

    }
}
